/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.chrpos;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import uk.ac.ox.well.t2d.parser.ColumnLoader;
import uk.ac.ox.well.t2d.types.ChromosomalRange;
import uk.ac.ox.well.t2d.types.ChromosomalRangeSet;

public class RangeFinder
implements Runnable {
    ChromosomalRangeSet chromRangeSet = new ChromosomalRangeSet();
    List<String[]> positions;
    File outputFile;

    public void setRanges(File f) throws Exception {
        ColumnLoader cl = new ColumnLoader(new int[]{0, 1, 2});
        List ranges = cl.toArrayList(f);
        HashSet<ChromosomalRange> crSet = new HashSet<ChromosomalRange>();
        for (String[] sa : ranges) {
            ChromosomalRange cr = new ChromosomalRange(sa[0], sa[1], sa[2]);
            crSet.add(cr);
        }
        this.chromRangeSet.addAll(crSet);
    }

    public void setPositions(File f) throws Exception {
        ColumnLoader cl = new ColumnLoader(new int[]{0, 1, 2});
        cl.setFromSeparator(',');
        this.positions = cl.toArrayList(f);
    }

    public void setOutputFile(File f) {
        this.outputFile = f;
    }

    @Override
    public void run() {
        try {
            this.runIt();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void runIt() throws Exception {
        PrintWriter pw = new PrintWriter(new FileWriter(this.outputFile));
        for (String[] sa : this.positions) {
            ChromosomalRange cp = this.chromRangeSet.getRange(sa[0], Long.valueOf(Long.parseLong(sa[1])));
            if (null == cp) continue;
            pw.print(sa[0]);
            pw.print("\t");
            pw.print(sa[1]);
            pw.print("\t");
            pw.print(sa[2]);
            pw.print("\t");
            pw.print(cp.getChromosome());
            pw.print("\t");
            pw.print(cp.getStart());
            pw.print("\t");
            pw.print(cp.getStop());
            pw.println();
        }
        pw.close();
    }
}

