/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.mafsnpsets;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.ox.well.t2d.parser.CellByCellParser;
import uk.ac.ox.well.t2d.parser.CellHandler;
import uk.ac.ox.well.t2d.parser.LabelledCellHandler;
import uk.ac.ox.well.t2d.parser.LineByLineParser;
import uk.ac.ox.well.t2d.parser.MapHandler;
import uk.ac.ox.well.t2d.parser.RecordHandler;
import uk.ac.ox.well.t2d.plink.PlinkReportAdaptor;

public class MAFParser {
    public static void main(String[] str) throws Exception {
        MAFParser mp = new MAFParser();
    }

    public void parse(File snps, File lmiss, File out) throws Exception {
        Set<String> snpSet = this.parseSnps(snps);
        System.out.println(snpSet.size());
        this.parseLmiss(snpSet, lmiss, out);
        this.thin(out);
    }

    public void parseLmiss(Set<String> snpSet, File lmiss, File out) throws Exception {
        LmissHandler lm = new LmissHandler(out, snpSet);
        LineByLineParser llp = new LineByLineParser((RecordHandler)new PlinkReportAdaptor((RecordHandler)new CellByCellParser((CellHandler)new LabelledCellHandler((MapHandler)lm))));
        llp.parse(lmiss);
        lm.pw.flush();
        lm.pw.close();
    }

    public Set<String> parseSnps(File snps) throws Exception {
        SnpHander h = new SnpHander();
        LineByLineParser llp = new LineByLineParser((RecordHandler)h);
        llp.parse(snps);
        return h.set;
    }

    public void thin(File miss) throws Exception {
        File out = new File(miss.getCanonicalPath() + ".thinned");
        BigDecimalLoader lm = new BigDecimalLoader();
        LineByLineParser llp = new LineByLineParser((RecordHandler)new PlinkReportAdaptor((RecordHandler)new CellByCellParser((CellHandler)lm)));
        llp.parse(miss);
        List<BigDecimal> list = lm.list;
        Collections.sort(list);
        ArrayList<BigDecimal> thinned = new ArrayList<BigDecimal>();
        for (int i = 0; i < list.size(); ++i) {
            if (0 != i % 10) continue;
            thinned.add(list.get(i));
        }
        PrintWriter pw = new PrintWriter(new FileOutputStream(out));
        for (BigDecimal t : thinned) {
            pw.println(t);
        }
        pw.close();
    }

    class BigDecimalLoader
    implements CellHandler {
        List<BigDecimal> list = new ArrayList<BigDecimal>();

        BigDecimalLoader() throws Exception {
        }

        public boolean startRecord(int lineNumber) {
            return true;
        }

        public boolean handleCell(int lineNumber, int cellIndex, CharSequence cellData) {
            if (cellIndex == 1) {
                BigDecimal bd = new BigDecimal(cellData.toString());
                this.list.add(bd);
            }
            return true;
        }

        public boolean endRecord(int lineNumber) {
            return true;
        }
    }

    class LmissHandler
    implements MapHandler {
        PrintWriter pw;
        Set<String> ss;

        LmissHandler(File out, Set<String> snpSet) throws Exception {
            this.ss = snpSet;
            this.pw = new PrintWriter(out);
        }

        public boolean handleRecord(int recordNumber, Map<String, String> recordData) {
            String snp = recordData.get("SNP");
            if (this.ss.contains(snp)) {
                String fmiss = recordData.get("F_MISS");
                this.pw.print(snp);
                this.pw.print("\t");
                this.pw.println(fmiss);
            }
            return true;
        }
    }

    class SnpHander
    implements RecordHandler {
        Set<String> set = new HashSet<String>();

        SnpHander() {
        }

        public boolean handleRecord(long lineNumber, CharSequence lineData) throws Exception {
            this.set.add(lineData.toString());
            return true;
        }
    }
}

