/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.neelam;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.ox.well.t2d.beans.Bean;
import uk.ac.ox.well.t2d.parser.ColumnLoader;
import uk.ac.ox.well.t2d.parser.LabelledMapLoader;

public class NeelamSampleRemapping
extends Bean {
    Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    int sldcsCases = 0;
    Map<String, String[]> sldcsPhenos;
    Map<String, List<String>> slydsPhenos;

    public NeelamSampleRemapping() throws Exception {
        LabelledMapLoader slydsLoader = new LabelledMapLoader("Study Identification No", new String[]{"Sex of the patient"});
        InputStream is2 = ((Object)((Object)this)).getClass().getResourceAsStream("SLYDS-T2D-phenos.txt");
        this.slydsPhenos = slydsLoader.loadMap(is2);
        this.logger.info("Loaded " + this.slydsPhenos.size() + " SLYDS phenotype entries");
        this.sldcsPhenos = this.loadSldcs();
        this.logger.info("Loaded " + this.slydsPhenos.size() + " SLYDS phenotype entries");
    }

    public static void main(String[] args) throws Exception {
        File fin = new File("/home/neil/Desktop/Nov24_NeelamRemappingAgain/neelam.fam");
        File fout = new File("/home/neil/Desktop/Nov24_NeelamRemappingAgain/neelam.fam.fixed");
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(new FileInputStream(fin)));
        PrintWriter pw = new PrintWriter(fout);
        NeelamSampleRemapping nsr = new NeelamSampleRemapping();
        nsr.transform(lnr, pw);
        pw.close();
    }

    public void transform(LineNumberReader lnr, PrintWriter w) throws Exception {
        String line;
        while (null != (line = lnr.readLine())) {
            String[] splits = line.split("\\s");
            String id = splits[0];
            this.write(id, w);
        }
        w.flush();
    }

    public Map<String, String[]> loadSldcs() throws Exception {
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        ColumnLoader loader = new ColumnLoader(new int[]{0, 2, 3, 4});
        InputStreamReader r = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("sldcs-amended-databasefile-200910-ajb-1.tsv"));
        List arrays = loader.toArrayList((Reader)r);
        arrays.remove(0);
        for (String[] strs : arrays) {
            map.put(strs[0], strs);
        }
        return map;
    }

    public void write(String id, PrintWriter pw) throws Exception {
        if (id.startsWith("SLDCS")) {
            String sid = null;
            String sex = null;
            String ccs = null;
            String[] strs = this.sldcsPhenos.get(id);
            if (null == strs) {
                this.logger.info("Could not find INFO for SLDCS SAMPLE: " + id);
            } else {
                sid = strs[1];
                sex = strs[2];
                if (sex.equalsIgnoreCase("X")) {
                    sex = null;
                }
                if ((ccs = strs[3]).equalsIgnoreCase("0")) {
                    ccs = "1";
                } else if (ccs.equalsIgnoreCase("1")) {
                    ++this.sldcsCases;
                    this.logger.info("SLDCS SAMPLE is a CASE!: " + id + ", case number " + this.sldcsCases);
                    ccs = "2";
                } else {
                    ccs = ccs.equalsIgnoreCase("X") ? null : null;
                }
            }
            this.write(sid, sex, ccs, pw);
        } else {
            List<String> list = this.slydsPhenos.get(id);
            if (null == list || list.isEmpty()) {
                this.logger.info("Could not find SEX INFO for SLYDS SAMPLE: " + id);
            }
            this.write(id, list.get(0), "2", pw);
        }
    }

    public void write(String id, String sex, String cc, PrintWriter pw) {
        if (this.isNullOrEmpty(sex)) {
            sex = "-9";
        }
        if (this.isNullOrEmpty(cc)) {
            cc = "-9";
        }
        pw.print(id);
        pw.print("\t");
        pw.print(id);
        pw.print("\t0\t0\t");
        pw.print(sex);
        pw.print("\t");
        pw.print(cc);
        pw.println();
    }
}

