/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.reports.imputation;

import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.reports.imputation.ImputationReportBean;

public abstract class AbstractFormatter {
    protected Logger logger = LoggerFactory.getLogger(this.getClass().getName());
    protected VelocityEngine ve = new VelocityEngine();

    public AbstractFormatter() {
        this.ve.setProperty("resource.loader", "classpath");
        this.ve.setProperty("classpath.resource.loader.description", "Velocity Classpath Resource Loader");
        this.ve.setProperty("classpath.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.ve.init();
    }

    protected void outputReport(Path p, String data) {
        byte[] ba = data.getBytes(StandardCharsets.UTF_8);
        try {
            Files.write(p, ba, new OpenOption[0]);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected final Template loadTemplate(String location) {
        try {
            return this.ve.getTemplate(location);
        }
        catch (ResourceNotFoundException rnfe) {
            throw new RuntimeException(rnfe);
        }
        catch (ParseErrorException pee) {
            throw new RuntimeException(pee);
        }
        catch (MethodInvocationException mie) {
            throw new RuntimeException(mie);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String format(ImputationReportBean bean) {
        VelocityContext context = new VelocityContext();
        context.put("bean", bean);
        StringWriter sw = new StringWriter();
        Template t = this.loadTemplate(this.getLocation());
        t.merge(context, sw);
        return sw.toString();
    }

    protected abstract String getLocation();
}

