/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.reports.imputation;

import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import uk.ac.ox.well.t2d.reports.imputation.AbstractFormatter;
import uk.ac.ox.well.t2d.reports.imputation.ImputationReportBean;

public class CrossCohortFormatter
extends AbstractFormatter {
    public static String HTML_PLOT_TEMPLATE = "uk/ac/ox/well/t2d/reports/imputation/templates/CrossCohortImputationReportTemplateHtml.vm";
    private Map<String, Object> topLevelObjects;
    private List<ImputationReportBean> reportBeans;
    private final Map<String, ImputationReportBean> perCohort = new LinkedHashMap<String, ImputationReportBean>();
    private final Set<String> chromosomes = new LinkedHashSet<String>();

    @Override
    protected String getLocation() {
        return HTML_PLOT_TEMPLATE;
    }

    public void setReportBeans(List<ImputationReportBean> reportBeans) {
        this.reportBeans = reportBeans;
    }

    public void setTopLevelObjects(Map<String, Object> map) {
        this.topLevelObjects = map;
    }

    public String format() {
        this.perCohort.clear();
        this.chromosomes.clear();
        this.reportBeans.forEach(b -> {
            this.perCohort.put(b.getCohortName(), (ImputationReportBean)b);
            this.chromosomes.addAll(b.getChromosomeData().keySet());
        });
        Map<String, Map<String, Object>> afPlots = this.groupPerChromosomeObjects("AF.png");
        Map<String, Map<String, Object>> manInfoPlots = this.groupPerChromosomeObjects("Manhattan.Info.png");
        Map<String, Map<String, Object>> chrPosOrderPlots = this.groupPerChromosomeObjects("POSITION.ROW.png");
        VelocityContext context = new VelocityContext();
        context.put("chromosomes", this.chromosomes);
        context.put("cohorts", this.perCohort);
        context.put("afPlots", afPlots);
        context.put("manInfoPlots", manInfoPlots);
        context.put("chrPosOrderPlots", chrPosOrderPlots);
        context.put("topLevelObjects", this.topLevelObjects);
        StringWriter sw = new StringWriter();
        Template t = this.loadTemplate(this.getLocation());
        t.merge(context, sw);
        return sw.toString();
    }

    protected Map<String, Map<String, Object>> groupPerChromosomeObjects(String objName) {
        LinkedHashMap<String, Map<String, Object>> rMap = new LinkedHashMap<String, Map<String, Object>>();
        this.chromosomes.forEach(chr -> {
            LinkedHashMap iMap = new LinkedHashMap();
            this.perCohort.keySet().forEach(name -> {
                Object o = null;
                ImputationReportBean irb = this.perCohort.get(name);
                Map<String, Object> objMap = irb.getChromosomeData().get(chr);
                if (null != objMap) {
                    o = objMap.get(objName);
                }
                iMap.put(name, o);
                System.out.println("groupPerChromosomeObjects " + objName + " & " + chr + ".... " + name + " & " + o.hashCode());
            });
            rMap.put((String)chr, iMap);
        });
        return rMap;
    }
}

