/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.reports.imputation;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.reports.imputation.ChrComparator;
import uk.ac.ox.well.t2d.reports.imputation.ImputationReportBean;
import uk.ac.ox.well.t2d.reports.imputation.ObjectLoader;

public class DirectoryManager
implements Runnable {
    public static final Pattern CHR_PATTERN = Pattern.compile(".*\\.chr(.*)\\..*");
    public static final Pattern GENOME_WIDE_PATTERN = Pattern.compile(".*\\.GW\\..*");
    protected static final Logger logger = LoggerFactory.getLogger(DirectoryManager.class);
    protected ObjectLoader ldr = new ObjectLoader();
    String project;
    String label = null;
    Path directory = null;
    List<Path> files = new ArrayList<Path>();
    Map<String, List<Path>> filegroups = new TreeMap<String, List<Path>>();
    List<ImputationReportBean> beans = new ArrayList<ImputationReportBean>();

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String l) {
        this.project = l;
    }

    public void setInputDirectory(String p) {
        this.setInputDirectory(Paths.get(p, new String[0]));
    }

    public void setInputDirectory(Path p) {
        this.directory = p;
    }

    public Path getInputDirectory() {
        return this.directory;
    }

    public List<ImputationReportBean> getReportBeans() {
        return this.beans;
    }

    @Override
    public void run() {
        if (null == this.getProject()) {
            throw new RuntimeException("No project label set");
        }
        if (null == this.getLabel()) {
            throw new RuntimeException("No cohort label set");
        }
        if (null == this.getInputDirectory()) {
            throw new RuntimeException("No input directory set");
        }
        try {
            this.discoverChildFiles();
            logger.info(String.format("Found %,d files in directory %s", this.files.size(), this.directory));
            this.partitionStudies();
            this.filegroups.entrySet().forEach(e -> this.beans.add(this.generateBean((String)e.getKey(), (List)e.getValue())));
        }
        catch (Exception re) {
            throw new RuntimeException(re);
        }
    }

    public ImputationReportBean generateBean(String label, List<Path> paths) {
        ImputationReportBean bean = new ImputationReportBean();
        bean.setCohortName(label);
        logger.info(String.format("Formatting report for filegroup %s", label));
        Map<String, List<Path>> perChrPaths = this.partitionChromosomes(paths);
        logger.info(String.format("Found files for %d chromosome(s): %s", perChrPaths.size(), perChrPaths.keySet()));
        Map<String, Map<String, Object>> perChrObjs = this.loadObjectData(perChrPaths);
        bean.setChromosomeData(perChrObjs);
        List<Path> gwPaths = this.collectGenomeWidePaths(paths);
        Map<String, Object> gwData = this.loadObjectData(gwPaths);
        logger.info(String.format("Found %d genome-wide files: %s", gwData.size(), gwData.keySet()));
        bean.setGenomeWideData(gwData);
        Path md = this.collectMetadataPath(paths);
        if (null != md) {
            Map<String, String> mdata = this.ldr.loadMapData(md);
            bean.setMetadata(mdata);
            logger.info(String.format("Found metadata: %s", mdata));
        } else {
            logger.info(String.format("Metadata file not found.", new Object[0]));
        }
        return bean;
    }

    public Map<String, Map<String, Object>> loadObjectData(Map<String, List<Path>> perChr) {
        TreeMap<String, Map<String, Object>> map = new TreeMap<String, Map<String, Object>>(new ChrComparator());
        perChr.entrySet().forEach(e -> {
            Map<String, Object> objMap = this.loadObjectData((List)e.getValue());
            logger.info(String.format("Loaded %d data objects for chromosome %s. Types: %s", objMap.size(), e.getKey(), objMap.keySet()));
            map.put((String)e.getKey(), objMap);
        });
        return map;
    }

    public Map<String, Object> loadObjectData(List<Path> paths) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        paths.forEach(p -> this.loadObjectData((Map<String, Object>)map, (Path)p));
        return map;
    }

    public void loadObjectData(Map<String, Object> map, Path p) {
        String[] hsplit = p.getFileName().toString().split("-");
        if (hsplit.length < 2) {
            logger.warn("Path %s did not split properly using hyphen separator. Expecting at least 2 components.", p);
        }
        String type = hsplit[0];
        String[] psplit = p.getFileName().toString().split("\\.");
        if (psplit.length < 2) {
            logger.warn("Path %s did not split properly using period separator. Expecting at least 2 components.", p);
        }
        String ext = psplit[psplit.length - 1];
        String key = type + "." + ext;
        Object o = this.ldr.loadObjectByType(p, ext);
        if (null != o) {
            map.put(key, o);
        }
    }

    public Path collectMetadataPath(List<Path> paths) {
        Path rp = paths.stream().filter(p -> p.getFileName().toString().matches("Meta-.*\\.txt")).findFirst().get();
        return rp;
    }

    public List<Path> collectGenomeWidePaths(List<Path> paths) {
        ArrayList<Path> lst = new ArrayList<Path>();
        paths.forEach(p -> {
            Matcher m = GENOME_WIDE_PATTERN.matcher(p.getFileName().toString());
            if (m.matches()) {
                lst.add((Path)p);
            }
        });
        return lst;
    }

    public Map<String, List<Path>> partitionChromosomes(List<Path> paths) {
        TreeMap<String, List<Path>> map = new TreeMap<String, List<Path>>();
        paths.forEach(p -> {
            Matcher m = CHR_PATTERN.matcher(p.getFileName().toString());
            if (m.matches()) {
                String grp = m.group(1);
                ArrayList<Path> lst = (ArrayList<Path>)map.get(grp);
                if (null == lst) {
                    lst = new ArrayList<Path>();
                    map.put(grp, lst);
                }
                lst.add((Path)p);
            }
        });
        return map;
    }

    protected void discoverChildFiles() throws IOException {
        DirectoryStream.Filter<Path> filter = file -> Files.isRegularFile(file, new LinkOption[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.getInputDirectory(), filter);){
            stream.forEach(path -> this.files.add((Path)path));
        }
    }

    protected void partitionStudies() throws IOException {
        String tlbl;
        List<Path> group;
        int i = 1;
        while (!(group = this.groupPaths(tlbl = i + "." + this.getLabel(), this.files)).isEmpty()) {
            this.filegroups.put(tlbl, group);
            logger.info(String.format("Found secondary filegroup using label %s, %d files found.", tlbl, group.size()));
            ++i;
        }
        List<Path> group2 = this.groupPaths(this.getLabel(), this.files);
        if (!group2.isEmpty()) {
            logger.info(String.format("Found primary filegroup using label %s, %d files found.", this.getLabel(), group2.size()));
            this.filegroups.put(this.getLabel(), group2);
        } else {
            logger.info("No primary filegroup found using label %s as expected", (Object)this.getLabel());
        }
    }

    public List<Path> groupPaths(String lbl, List<Path> paths) {
        String searchTerm = "-" + lbl + ".";
        ArrayList<Path> group = new ArrayList<Path>();
        for (Path p : paths) {
            if (!p.getFileName().toString().contains(searchTerm)) continue;
            group.add(p);
        }
        return group;
    }
}

