/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.tables;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.tables.ColumnIndexer;
import uk.ac.ox.well.t2d.tables.Index;
import uk.ac.ox.well.t2d.tables.NoSuchColumnException;
import uk.ac.ox.well.t2d.tables.RandomAccessRow;

public class IndexedFileTable {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ColumnIndexer columns;
    protected List<Index> indexes;
    protected File file = null;
    protected RandomAccessFile raf = null;

    public IndexedFileTable() {
        this("\t");
    }

    public IndexedFileTable(String separator) {
        this.columns = new ColumnIndexer(separator);
        this.indexes = new ArrayList<Index>();
    }

    public void setFile(File file) throws IOException {
        this.file = file;
        this.raf = new RandomAccessFile(file, "r");
    }

    public void addIndex(Index i) {
        this.indexes.add(i);
    }

    public File getFile() {
        return this.file;
    }

    public Collection<Index> getIndexes() {
        return Collections.unmodifiableCollection(this.indexes);
    }

    public void initialize() throws IOException {
        for (Index i : this.indexes) {
            i.load();
        }
        ArrayList<Index> unbuilt = new ArrayList<Index>();
        for (Index i : this.indexes) {
            if (i.isBuilt()) continue;
            unbuilt.add(i);
        }
        this.scan(unbuilt);
        for (Index i : unbuilt) {
            i.store();
        }
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public void scan(Collection<Index> indexes) throws IOException {
        while (true) {
            long pos = this.raf.getFilePointer();
            String line = this.raf.readLine();
            if (null == line) break;
            if (0L == pos) {
                this.columns.load(line);
                continue;
            }
            if (indexes.isEmpty()) break;
            this.handleLine(pos, line, indexes);
        }
    }

    public RandomAccessRow getEntry(long pos) throws IOException {
        this.raf.seek(pos);
        String line = this.raf.readLine();
        if (null == line) {
            throw new IOException("No entry found at position: " + pos);
        }
        return this.columns.toRow(pos, line);
    }

    public Iterator<RandomAccessRow> getEntries(Collection<Long> positions) {
        return new EntryIteratorImpl(positions);
    }

    void handleLine(long pos, String line, Collection<Index> indexes) {
        RandomAccessRow r = this.columns.toRow(pos, line);
        this.indexEntry(r, indexes);
    }

    void indexEntry(RandomAccessRow data, Collection<Index> indexes) {
        for (Index i : indexes) {
            try {
                i.indexEntry(data);
            }
            catch (NoSuchColumnException ex) {
                this.logger.error("Column Not Found: " + ex.getMessage());
            }
        }
    }

    class EntryIteratorImpl
    implements Iterator<RandomAccessRow> {
        Iterator<Long> it;

        EntryIteratorImpl(Iterator<Long> positions) {
            this.it = positions;
        }

        EntryIteratorImpl(Collection<Long> positions) {
            this(positions.iterator());
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public RandomAccessRow next() {
            try {
                Long pos = this.it.next();
                return IndexedFileTable.this.getEntry(pos);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported. Read only iterator.");
        }
    }
}

