/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.tables;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import uk.ac.ox.well.t2d.lang.StringUtilities;
import uk.ac.ox.well.t2d.tables.BasicFileIndex;
import uk.ac.ox.well.t2d.tables.Index;
import uk.ac.ox.well.t2d.tables.RandomAccessRow;

public abstract class ValueIndex
extends BasicFileIndex
implements Index {
    public abstract String getValue(RandomAccessRow var1);

    @Override
    public void indexEntry(RandomAccessRow data) {
        String value = this.getValue(data);
        this.registerPosition(value, data.getPosition());
    }

    @Override
    public SortedSet<Long> getPositions(String searchTerm) {
        String existing = this.getProperty(searchTerm);
        if (null == existing) {
            return new TreeSet<Long>();
        }
        return this.fromString(existing);
    }

    void registerPosition(String key, long position) {
        SortedSet<Long> ls = this.getPositions(key);
        ls.add(new Long(position));
        this.setProperty(key, this.toString(ls));
    }

    SortedSet<Long> fromString(String str) {
        List strs = StringUtilities.splitCommaSeparated((String)str);
        TreeSet<Long> ls = new TreeSet<Long>();
        for (String lstr : strs) {
            ls.add(Long.parseLong(lstr));
        }
        return ls;
    }

    String toString(SortedSet<Long> ls) {
        return StringUtilities.format(ls);
    }
}

