"use strict";(self.webpackChunkwhg_training_resources=self.webpackChunkwhg_training_resources||[]).push([[380],{3905:(e,t,n)=>{n.d(t,{Zo:()=>g,kt:()=>m});var a=n(7294);function o(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function r(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var a=Object.getOwnPropertySymbols(e);t&&(a=a.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,a)}return n}function i(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?r(Object(n),!0).forEach((function(t){o(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):r(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}function s(e,t){if(null==e)return{};var n,a,o=function(e,t){if(null==e)return{};var n,a,o={},r=Object.keys(e);for(a=0;a<r.length;a++)n=r[a],t.indexOf(n)>=0||(o[n]=e[n]);return o}(e,t);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);for(a=0;a<r.length;a++)n=r[a],t.indexOf(n)>=0||Object.prototype.propertyIsEnumerable.call(e,n)&&(o[n]=e[n])}return o}var l=a.createContext({}),c=function(e){var t=a.useContext(l),n=t;return e&&(n="function"==typeof e?e(t):i(i({},t),e)),n},g=function(e){var t=c(e.components);return a.createElement(l.Provider,{value:t},e.children)},d={inlineCode:"code",wrapper:function(e){var t=e.children;return a.createElement(a.Fragment,{},t)}},A=a.forwardRef((function(e,t){var n=e.components,o=e.mdxType,r=e.originalType,l=e.parentName,g=s(e,["components","mdxType","originalType","parentName"]),A=c(n),m=o,p=A["".concat(l,".").concat(m)]||A[m]||d[m]||r;return n?a.createElement(p,i(i({ref:t},g),{},{components:n})):a.createElement(p,i({ref:t},g))}));function m(e,t){var n=arguments,o=t&&t.mdxType;if("string"==typeof e||o){var r=n.length,i=new Array(r);i[0]=A;var s={};for(var l in t)hasOwnProperty.call(t,l)&&(s[l]=t[l]);s.originalType=e,s.mdxType="string"==typeof e?e:o,i[1]=s;for(var c=2;c<r;c++)i[c]=n[c];return a.createElement.apply(null,i)}return a.createElement.apply(null,n)}A.displayName="MDXCreateElement"},9165:(e,t,n)=>{n.r(t),n.d(t,{assets:()=>l,contentTitle:()=>i,default:()=>d,frontMatter:()=>r,metadata:()=>s,toc:()=>c});var a=n(7462),o=(n(7294),n(3905));const r={sidebar_position:3},i="Working with genome annotation files in R",s={unversionedId:"bioinformatics/exploring_genomic_data_in_R/CM4-3_genomic_data_in_R_gff",id:"bioinformatics/exploring_genomic_data_in_R/CM4-3_genomic_data_in_R_gff",title:"Working with genome annotation files in R",description:"Author: Wojciech Lason",source:"@site/docs/bioinformatics/exploring_genomic_data_in_R/CM4-3_genomic_data_in_R_gff.md",sourceDirName:"bioinformatics/exploring_genomic_data_in_R",slug:"/bioinformatics/exploring_genomic_data_in_R/CM4-3_genomic_data_in_R_gff",permalink:"/bioinformatics/training/MSc_GM_2022/CM4-3-genomic_data/tutorials/bioinformatics/exploring_genomic_data_in_R/CM4-3_genomic_data_in_R_gff",draft:!1,editUrl:"https://github.com/whg-training/whg-training-resources/edit/main/docs/bioinformatics/exploring_genomic_data_in_R/CM4-3_genomic_data_in_R_gff.md",tags:[],version:"current",sidebarPosition:3,frontMatter:{sidebar_position:3},sidebar:"tutorialSidebar",previous:{title:"Exploring FASTA files",permalink:"/bioinformatics/training/MSc_GM_2022/CM4-3-genomic_data/tutorials/bioinformatics/exploring_genomic_data_in_R/exploring_sequence_files"},next:{title:"Linking exons to variants",permalink:"/bioinformatics/training/MSc_GM_2022/CM4-3-genomic_data/tutorials/bioinformatics/exploring_genomic_data_in_R/variant_annotations"}},l={},c=[{value:"Getting started",id:"getting-started",level:2},{value:"Reading the gene annotation file into R",id:"reading-the-gene-annotation-file-into-r",level:2},{value:"Looking at the contents of the gene annotation file",id:"looking-at-the-contents-of-the-gene-annotation-file",level:2},{value:"Plotting data",id:"plotting-data",level:2},{value:"FUT genes",id:"fut-genes",level:2}],g={toc:c};function d(e){let{components:t,...r}=e;return(0,o.kt)("wrapper",(0,a.Z)({},g,r,{components:t,mdxType:"MDXLayout"}),(0,o.kt)("h1",{id:"working-with-genome-annotation-files-in-r"},"Working with genome annotation files in R"),(0,o.kt)("p",null,(0,o.kt)("strong",{parentName:"p"},"Author"),": Wojciech Lason\n",(0,o.kt)("strong",{parentName:"p"},"Contributor"),": Helen Lockstone"),(0,o.kt)("p",null,"Welcome! In this tutorial we will use the R programming environment to explore human gene annotations.\nThis tutorial has two main objectives:"),(0,o.kt)("ul",null,(0,o.kt)("li",{parentName:"ul"},"To demonstrate and practice some useful ways of handling data in R"),(0,o.kt)("li",{parentName:"ul"},"To continue to get you familiar with gene annotation files")),(0,o.kt)("h2",{id:"getting-started"},"Getting started"),(0,o.kt)("p",null,"First create a new folder on your computer to work in and then open RStudio. We need to tell R where this is:"),(0,o.kt)("ul",null,(0,o.kt)("li",{parentName:"ul"},"from the top menu bar, select 'Session' "),(0,o.kt)("li",{parentName:"ul"},"select 'Set Working Directory'"),(0,o.kt)("li",{parentName:"ul"},"'Choose Directory'"),(0,o.kt)("li",{parentName:"ul"},"navigate through your file system to the new directory folder"),(0,o.kt)("li",{parentName:"ul"},"click 'Open'")),(0,o.kt)("p",null,"In this tutorial, we will use a file obtained from ",(0,o.kt)("a",{parentName:"p",href:"https://ftp.ensembl.org/pub/current_gff3/homo_sapiens/"},"Ensembl")," containing annotations for (human) genes on chromosome 19. This subset of genome annotations will be used to illustrate the file content, organisation and perform some typical tasks."),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},"download.file(url = 'http://ftp.ensembl.org/pub/release-107/gff3/homo_sapiens/Homo_sapiens.GRCh38.107.chromosome.19.gff3.gz', destfile = 'Homo_sapiens.GRCh38.107.chromosome.19.gff3.gz')\n")),(0,o.kt)("div",{className:"admonition admonition-note alert alert--secondary"},(0,o.kt)("div",{parentName:"div",className:"admonition-heading"},(0,o.kt)("h5",{parentName:"div"},(0,o.kt)("span",{parentName:"h5",className:"admonition-icon"},(0,o.kt)("svg",{parentName:"span",xmlns:"http://www.w3.org/2000/svg",width:"14",height:"16",viewBox:"0 0 14 16"},(0,o.kt)("path",{parentName:"svg",fillRule:"evenodd",d:"M6.3 5.69a.942.942 0 0 1-.28-.7c0-.28.09-.52.28-.7.19-.18.42-.28.7-.28.28 0 .52.09.7.28.18.19.28.42.28.7 0 .28-.09.52-.28.7a1 1 0 0 1-.7.3c-.28 0-.52-.11-.7-.3zM8 7.99c-.02-.25-.11-.48-.31-.69-.2-.19-.42-.3-.69-.31H6c-.27.02-.48.13-.69.31-.2.2-.3.44-.31.69h1v3c.02.27.11.5.31.69.2.2.42.31.69.31h1c.27 0 .48-.11.69-.31.2-.19.3-.42.31-.69H8V7.98v.01zM7 2.3c-3.14 0-5.7 2.54-5.7 5.68 0 3.14 2.56 5.7 5.7 5.7s5.7-2.55 5.7-5.7c0-3.15-2.56-5.69-5.7-5.69v.01zM7 .98c3.86 0 7 3.14 7 7s-3.14 7-7 7-7-3.12-7-7 3.14-7 7-7z"}))),"Note")),(0,o.kt)("div",{parentName:"div",className:"admonition-content"},(0,o.kt)("p",{parentName:"div"},"Gene annotation files contain information about gene structure (exons, transcripts, coding sequence etc.), identifiers, position in the genome and other details. There are different sources and varieties of gene annotations and a standard file format exists to store them; this is known as GFF3 (General Feature Format v3) or the older GTF (Gene Transfer Format).\nSee these pages for more information about gff files from ",(0,o.kt)("a",{parentName:"p",href:"https://www.ensembl.org/info/website/upload/gff3.html"},"Ensembl")," and ",(0,o.kt)("a",{parentName:"p",href:"https://www.ncbi.nlm.nih.gov/genbank/genomes_gff/"},"NCBI")),(0,o.kt)("p",{parentName:"div"},"GRCh38 refers to the name of the genome assembly - this is the latest 'major release' of the human genome from the Genome Reference Consortium (GRC), with 107 referring to the 'minor release' version."))),(0,o.kt)("p",null,"The main content of the file is some tab-delimited text split into 9 columns, each row corresponding to an annotation entry. These rows start after several 'header' rows with general information about the file; header rows start with a # symbol and are just one column. "),(0,o.kt)("table",null,(0,o.kt)("thead",{parentName:"table"},(0,o.kt)("tr",{parentName:"thead"},(0,o.kt)("th",{parentName:"tr",align:"left"},"Column"),(0,o.kt)("th",{parentName:"tr",align:"left"},"Description"))),(0,o.kt)("tbody",{parentName:"table"},(0,o.kt)("tr",{parentName:"tbody"},(0,o.kt)("td",{parentName:"tr",align:"left"},"Sequence name (",(0,o.kt)("inlineCode",{parentName:"td"},"seqid"),")"),(0,o.kt)("td",{parentName:"tr",align:"left"},"Name of the chromosome or scaffold. Watch out for differences between annotation consortia - e.g. chromosome 1 could be denoted as 'chr1' or just '1'")),(0,o.kt)("tr",{parentName:"tbody"},(0,o.kt)("td",{parentName:"tr",align:"left"},"Source (",(0,o.kt)("inlineCode",{parentName:"td"},"source"),")"),(0,o.kt)("td",{parentName:"tr",align:"left"},"Annotation source. Includes 'ensembl' - automatic annotation program and 'havana' - manual annotation by HAVANA group")),(0,o.kt)("tr",{parentName:"tbody"},(0,o.kt)("td",{parentName:"tr",align:"left"},"Feature type (",(0,o.kt)("inlineCode",{parentName:"td"},"type"),")"),(0,o.kt)("td",{parentName:"tr",align:"left"},"Region type. Examples include coding sequence (CDS), exon (exon), 3' UTR (three_prime_UTR), 5' UTR (five_prime_UTR)")),(0,o.kt)("tr",{parentName:"tbody"},(0,o.kt)("td",{parentName:"tr",align:"left"},"Start (",(0,o.kt)("inlineCode",{parentName:"td"},"start"),")"),(0,o.kt)("td",{parentName:"tr",align:"left"},"Genomic coordinate where the annotated sequence starts")),(0,o.kt)("tr",{parentName:"tbody"},(0,o.kt)("td",{parentName:"tr",align:"left"},"End (",(0,o.kt)("inlineCode",{parentName:"td"},"end"),")"),(0,o.kt)("td",{parentName:"tr",align:"left"},"Genomic coordinate where the annotated sequence ends")),(0,o.kt)("tr",{parentName:"tbody"},(0,o.kt)("td",{parentName:"tr",align:"left"},"Score (",(0,o.kt)("inlineCode",{parentName:"td"},"score"),")"),(0,o.kt)("td",{parentName:"tr",align:"left"},"A numeric value normally referring to the confidence score of the annotated sequence")),(0,o.kt)("tr",{parentName:"tbody"},(0,o.kt)("td",{parentName:"tr",align:"left"},"Strand (",(0,o.kt)("inlineCode",{parentName:"td"},"strand"),")"),(0,o.kt)("td",{parentName:"tr",align:"left"},"Direction of the sequence in double-stranded DNA. Can be either '+' (forward/sense strand) or '-' (reverse/antisense strand)")),(0,o.kt)("tr",{parentName:"tbody"},(0,o.kt)("td",{parentName:"tr",align:"left"},"ORF (",(0,o.kt)("inlineCode",{parentName:"td"},"phase"),")"),(0,o.kt)("td",{parentName:"tr",align:"left"},"Refers to the start of the open reading frame (ORF). Can be 0, 1, or 2 - 0 indicates that the first base of the feature is the first base of a codon")),(0,o.kt)("tr",{parentName:"tbody"},(0,o.kt)("td",{parentName:"tr",align:"left"},"Attributes (",(0,o.kt)("inlineCode",{parentName:"td"},"attributes"),")"),(0,o.kt)("td",{parentName:"tr",align:"left"},"A list of name-value pairs separated by semicolons, in the format 'name=value'. Attributes differ in type and number based on the feature type and the annotation program")))),(0,o.kt)("div",{className:"admonition admonition-note alert alert--secondary"},(0,o.kt)("div",{parentName:"div",className:"admonition-heading"},(0,o.kt)("h5",{parentName:"div"},(0,o.kt)("span",{parentName:"h5",className:"admonition-icon"},(0,o.kt)("svg",{parentName:"span",xmlns:"http://www.w3.org/2000/svg",width:"14",height:"16",viewBox:"0 0 14 16"},(0,o.kt)("path",{parentName:"svg",fillRule:"evenodd",d:"M6.3 5.69a.942.942 0 0 1-.28-.7c0-.28.09-.52.28-.7.19-.18.42-.28.7-.28.28 0 .52.09.7.28.18.19.28.42.28.7 0 .28-.09.52-.28.7a1 1 0 0 1-.7.3c-.28 0-.52-.11-.7-.3zM8 7.99c-.02-.25-.11-.48-.31-.69-.2-.19-.42-.3-.69-.31H6c-.27.02-.48.13-.69.31-.2.2-.3.44-.31.69h1v3c.02.27.11.5.31.69.2.2.42.31.69.31h1c.27 0 .48-.11.69-.31.2-.19.3-.42.31-.69H8V7.98v.01zM7 2.3c-3.14 0-5.7 2.54-5.7 5.68 0 3.14 2.56 5.7 5.7 5.7s5.7-2.55 5.7-5.7c0-3.15-2.56-5.69-5.7-5.69v.01zM7 .98c3.86 0 7 3.14 7 7s-3.14 7-7 7-7-3.12-7-7 3.14-7 7-7z"}))),"Note")),(0,o.kt)("div",{parentName:"div",className:"admonition-content"},(0,o.kt)("p",{parentName:"div"},"If you want to practice your command line skills, you can try using the ",(0,o.kt)("inlineCode",{parentName:"p"},"curl"),", ",(0,o.kt)("inlineCode",{parentName:"p"},"gunzip")," and ",(0,o.kt)("inlineCode",{parentName:"p"},"less")," commands  to get the file and inspect the contents."))),(0,o.kt)("h2",{id:"reading-the-gene-annotation-file-into-r"},"Reading the gene annotation file into R"),(0,o.kt)("p",null,"In R, we can use the standard function ",(0,o.kt)("inlineCode",{parentName:"p"},"read.delim()"),", which reads any delimited file (fields separated by tab, comma, etc.), to\nread the gene annotation file into memory and examine it. As the GFF does not include column names, we will specify ",(0,o.kt)("inlineCode",{parentName:"p"},"header = F"),"\nand tell R to ignore all the lines that start with '","#","' using the argument ",(0,o.kt)("inlineCode",{parentName:"p"},"comment.char")," - these happen to be default parameters\nof function ",(0,o.kt)("inlineCode",{parentName:"p"},"read.delim()"),", but it is good practice to be explicit about the function arguments in your code. We will give the\ncolumns meaningful names."),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},"gff <- read.delim('Homo_sapiens.GRCh38.107.chromosome.19.gff3.gz', comment.char = '#', header = FALSE, col.names = c('seqid', 'source', 'type', 'start', 'end', 'score', 'strand', 'phase', 'attributes'))\n\n# R automatically stores the data in a 2-dimensional object called a `data.frame`. We can check the dimensions of the object first:\ndim(gff)\n\n# inspect the first 6 rows and columns 1-8 (`head` displays the first 6 rows by default)\nhead(gff[,1:8])\n  seqid source       type start      end score strand phase\n1    19 GRCh38 chromosome     1 58617616     .      .     .\n2    19 havana pseudogene 60951    71626     .      -     .\n3    19 havana    lnc_RNA 60951    70976     .      -     .\n4    19 havana       exon 60951    61894     .      -     .\n5    19 havana       exon 66346    66499     .      -     .\n6    19 havana       exon 70928    70976     .      -     .\n")),(0,o.kt)("p",null,"As you can see, the first 8 columns are compact and readily readable. (A dot in any column '.' indicates no value for that particular feature). The 9th column 'attributes' poses more difficulty - it contains multiple fields separated by the ';' character, and different rows can contain different information depending on the type of feature being described. Let's take a look at it:"),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},'head(gff[,9])\n[1] "ID=chromosome:19;Alias=CM000681.2,chr19,NC_000019.10"                                                                                                                                                                               \n[2] "ID=gene:ENSG00000282458;Name=WASH5P;biotype=transcribed_processed_pseudogene;description=WASP family homolog 5%2C pseudogene [Source:HGNC Symbol%3BAcc:HGNC:33884];gene_id=ENSG00000282458;logic_name=havana_homo_sapiens;version=1"\n[3] "ID=transcript:ENST00000632506;Parent=gene:ENSG00000282458;Name=WASH5P-206;biotype=processed_transcript;tag=basic;transcript_id=ENST00000632506;transcript_support_level=1;version=1"                                                \n[4] "Parent=transcript:ENST00000632506;Name=ENSE00003783010;constitutive=0;ensembl_end_phase=-1;ensembl_phase=-1;exon_id=ENSE00003783010;rank=3;version=1"                                                                               \n[5] "Parent=transcript:ENST00000632506;Name=ENSE00003783498;constitutive=0;ensembl_end_phase=-1;ensembl_phase=-1;exon_id=ENSE00003783498;rank=2;version=1"                                                                               \n[6] "Parent=transcript:ENST00000632506;Name=ENSE00003781173;constitutive=0;ensembl_end_phase=-1;ensembl_phase=-1;exon_id=ENSE00003781173;rank=1;version=1"                                 \n')),(0,o.kt)("p",null,"There is some underlying organisation to this column for the file to conform to GFF3 format, but it is not readily apparent.\nHowever, take a closer look at this column and see if you can see any structure to the information that is stored there."),(0,o.kt)("p",null,"R helpfully determines automatically how best to store any data read in from a file. Data frame objects can have different types\nof data in their different columns and we can check how R has handled our file:"),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},"class(gff) # data.frame\n# looking at columns 1, 2 and 9 in turn\nclass(gff[,1]) # integer\nclass(gff[,2]) # character\nclass(gff[,9]) # character\n\n# looking at 2 particular elements of the data frame\nclass(gff[1,1]) # integer\nclass(gff[1,2]) # character\n")),(0,o.kt)("p",null,"The assigned data type or class will apply to the whole column. Text-based data is stored as a string of characters in R's\nmemory, so column 9 is just a very long string of characters."),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},"nchar(gff[2,9]) # this tells us that column 9 of row 2 has 227 characters\n")),(0,o.kt)("p",null,"To make the data in 'attributes' (column 9) more accessible, we could write a function that splits the long string based on the\n';' character, then split the resulting strings based on '=' character. This would generate substrings of different fields, and\nthen their respective values. But it is still complicated because there are a lot of fields in column 9 and they are simply\nomitted if there is no value/not applicable for a given feature (row)."),(0,o.kt)("p",null,"As an example, inspecting the second row with ",(0,o.kt)("inlineCode",{parentName:"p"},"gff[2,9]"),' would give us 6 field names: "ID", "Name", "description", "gene_id",\n"logic_name", "version" Inspecting another row (the 10th) with ',(0,o.kt)("inlineCode",{parentName:"p"},"gff[10,9]"),' shows us it has some different fields: "Parent",\n"Name", "constitutive", "ensembl_end_phase", "ensembl_phase", "exon_id", "rank", "version"'),(0,o.kt)("p",null,"Usefully, there is an R/Bioconductor package that can deal with this for us called ",(0,o.kt)("inlineCode",{parentName:"p"},"rtracklayer"),".\n",(0,o.kt)("a",{parentName:"p",href:"https://bioconductor.org/packages/release/bioc/html/rtracklayer.html"},"https://bioconductor.org/packages/release/bioc/html/rtracklayer.html")," ",(0,o.kt)("a",{parentName:"p",href:"https://www.bioconductor.org/"},"Bioconductor")," is a\nopen-source project developing software for Bioinformatics. If you are working with genomic data, chances are there is an\nexisting Bioconductor package that will perform common processing and analysis tasks."),(0,o.kt)("p",null,"We need to download and install the package to have access to its functionality:"),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},'if (!require("BiocManager", quietly = TRUE))\n    install.packages("BiocManager")\ninstall.packages("rtracklayer")\n')),(0,o.kt)("p",null,"and then load the library in the current R session:"),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},"library(rtracklayer)\n")),(0,o.kt)("p",null,"Now we can use ",(0,o.kt)("inlineCode",{parentName:"p"},"readGFF")," to handle reading the gff file into R. ",(0,o.kt)("inlineCode",{parentName:"p"},"readGFF")," is a bespoke function defined within the ",(0,o.kt)("inlineCode",{parentName:"p"},"rtracklayer"),"\npackage to read any GFF3 file into R, dealing with column 9 by separating the information into many columns. Looking at the\noutput will show there are now 28 columns compared to 9 before."),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},"gff <- readGFF('Homo_sapiens.GRCh38.107.chromosome.19.gff3.gz')\ngff <- as.data.frame(gff)\nhead(gff)\ndim(gff)\n")),(0,o.kt)("div",{className:"admonition admonition-note alert alert--secondary"},(0,o.kt)("div",{parentName:"div",className:"admonition-heading"},(0,o.kt)("h5",{parentName:"div"},(0,o.kt)("span",{parentName:"h5",className:"admonition-icon"},(0,o.kt)("svg",{parentName:"span",xmlns:"http://www.w3.org/2000/svg",width:"14",height:"16",viewBox:"0 0 14 16"},(0,o.kt)("path",{parentName:"svg",fillRule:"evenodd",d:"M6.3 5.69a.942.942 0 0 1-.28-.7c0-.28.09-.52.28-.7.19-.18.42-.28.7-.28.28 0 .52.09.7.28.18.19.28.42.28.7 0 .28-.09.52-.28.7a1 1 0 0 1-.7.3c-.28 0-.52-.11-.7-.3zM8 7.99c-.02-.25-.11-.48-.31-.69-.2-.19-.42-.3-.69-.31H6c-.27.02-.48.13-.69.31-.2.2-.3.44-.31.69h1v3c.02.27.11.5.31.69.2.2.42.31.69.31h1c.27 0 .48-.11.69-.31.2-.19.3-.42.31-.69H8V7.98v.01zM7 2.3c-3.14 0-5.7 2.54-5.7 5.68 0 3.14 2.56 5.7 5.7 5.7s5.7-2.55 5.7-5.7c0-3.15-2.56-5.69-5.7-5.69v.01zM7 .98c3.86 0 7 3.14 7 7s-3.14 7-7 7-7-3.12-7-7 3.14-7 7-7z"}))),"Note")),(0,o.kt)("div",{parentName:"div",className:"admonition-content"},(0,o.kt)("p",{parentName:"div"},"If you forget to load the library, R will give an error, saying it doesn't recognise the function ",(0,o.kt)("inlineCode",{parentName:"p"},"readGFF")," - this just means it\nis not available in what is known 'base' R i.e. the standard functionality."))),(0,o.kt)("p",null,"OK, this is much better now! Every field in the original 'attributes' column has its own column, and there is an 'NA' value if\nthe information for that row is missing. Let's see what the file contains."),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},'colnames(gff)\n\n## columns can be referred to in several ways\n## the following commands all extract the first 6 elements of the 3rd column\nhead(gff[,3])\nhead(gff[,"type"])\nhead(gff$type)\n\n## summarising the contents of the whole column\ntable(gff$type)\n\n')),(0,o.kt)("div",{className:"admonition admonition-tip alert alert--success"},(0,o.kt)("div",{parentName:"div",className:"admonition-heading"},(0,o.kt)("h5",{parentName:"div"},(0,o.kt)("span",{parentName:"h5",className:"admonition-icon"},(0,o.kt)("svg",{parentName:"span",xmlns:"http://www.w3.org/2000/svg",width:"12",height:"16",viewBox:"0 0 12 16"},(0,o.kt)("path",{parentName:"svg",fillRule:"evenodd",d:"M6.5 0C3.48 0 1 2.19 1 5c0 .92.55 2.25 1 3 1.34 2.25 1.78 2.78 2 4v1h5v-1c.22-1.22.66-1.75 2-4 .45-.75 1-2.08 1-3 0-2.81-2.48-5-5.5-5zm3.64 7.48c-.25.44-.47.8-.67 1.11-.86 1.41-1.25 2.06-1.45 3.23-.02.05-.02.11-.02.17H5c0-.06 0-.13-.02-.17-.2-1.17-.59-1.83-1.45-3.23-.2-.31-.42-.67-.67-1.11C2.44 6.78 2 5.65 2 5c0-2.2 2.02-4 4.5-4 1.22 0 2.36.42 3.22 1.19C10.55 2.94 11 3.94 11 5c0 .66-.44 1.78-.86 2.48zM4 14h5c-.23 1.14-1.3 2-2.5 2s-2.27-.86-2.5-2z"}))),"Helpful tip ")),(0,o.kt)("div",{parentName:"div",className:"admonition-content"},(0,o.kt)("p",{parentName:"div"},(0,o.kt)("inlineCode",{parentName:"p"},"table")," is an extremely useful R function, producing counts for the set of unique entries in a given column. This can help both to quickly summarise the data and spot any typos or inconsistencies in your input file - for example perhaps gender information was recorded as 'M' or 'm' in different parts of the file - in a very large file, this might be hard to spot by eye and cause some problems further down the line with your analysis. "))),(0,o.kt)("h2",{id:"looking-at-the-contents-of-the-gene-annotation-file"},"Looking at the contents of the gene annotation file"),(0,o.kt)("p",null,"Now we will try to find out some things about the genes on chromosome 19."),(0,o.kt)("p",null,"First, extract the details about chromosome 19 (note it is the first feature in the gff file). We'll store this in a new variable\nto 'save' it and be able to access it later."),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},"chr19 <- gff[1,]\n")),(0,o.kt)("p",null,"Now, let's subset the GFF file so that it contains entries described as ",(0,o.kt)("em",{parentName:"p"},"ensembl_havana")," in column 2 (source) Recall that\nsubsetting in R is possible using square brackets ",(0,o.kt)("inlineCode",{parentName:"p"},"[ ]")," or the function ",(0,o.kt)("inlineCode",{parentName:"p"},"subset()"),"."),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},"gff <- subset(gff, source == 'ensembl_havana')\ndim(gff)\n")),(0,o.kt)("p",null,"Our ",(0,o.kt)("inlineCode",{parentName:"p"},"gff")," object now has 38293 rows. The ",(0,o.kt)("em",{parentName:"p"},"ensembl_havana")," set of annotations combine computationally predicted genes with\nmanually-curated annotations from the HAVANA group. You can read more about those on the ",(0,o.kt)("a",{parentName:"p",href:"https://www.ensembl.org/info/genome/genebuild/annotation_merge.html"},"Ensembl\nwebsite"),"."),(0,o.kt)("p",null,"Note that we have over-written the previous ",(0,o.kt)("inlineCode",{parentName:"p"},"gff")," object containing all rows from the original file because we gave it the same\nname just now! Within the ensembl_havana annotations are still several different entry types, which can be summarised with\n",(0,o.kt)("inlineCode",{parentName:"p"},"table(gff$type)")),(0,o.kt)("p",null,"Inspect the number of each type and consider if they make sense. We can see there are 1343 gene features."),(0,o.kt)("p",null,'::: note Note\nIn R, there are always several ways to do something. We could alternatively find the number of entries matching "gene" in column\n2 as follows:'),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},'# using the which command\nlength(which(gff$type=="gene"))\n\n# or by \nsum(gff$type == "gene")\n')),(0,o.kt)("p",null,"A bit more about what the 2 commands above are doing: ",(0,o.kt)("inlineCode",{parentName:"p"},"which"),' returns the row numbers for which the specified condition is true -\nin this case that column 3 (type) contains the string "gene". Note that this is case-sensitive: ',(0,o.kt)("inlineCode",{parentName:"p"},'length(which(gff$type=="Gene"))'),"\nreturns 0!"),(0,o.kt)("p",null,(0,o.kt)("inlineCode",{parentName:"p"},"gff$type == 'gene'")," will return a boolean (TRUE/FALSE) value for every row in the dataframe. You can see this with the ",(0,o.kt)("inlineCode",{parentName:"p"},"head"),"\ncommand:"),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},'head(gff$type == "gene")\n')),(0,o.kt)("p",null,"What will the length of this output be? You can check with ",(0,o.kt)("inlineCode",{parentName:"p"},'length(gff$type == "gene")')),(0,o.kt)("p",null,"To count the number of 'TRUE' values, we use the property that TRUE is equal to 1 and FALSE is equal to 0. Therefore, sum of TRUE\noccurences is the number of rows that correspond to gene entries in our GFF file\n:::"),(0,o.kt)("p",null,"Now let's take a closer look at these 1343 genes on chromosome 19. "),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},'genes <- gff[gff$type == "gene", ]  #Subset the data frame, keeping all columns\n\nnrow(genes) # 1343, as we found above\n')),(0,o.kt)("p",null,"It would be interesting to see what proportion of genes lie on each strand of the DNA, denoted as + (sense) and - (antisense) in the gff file. We can produce count summaries using the fuction ",(0,o.kt)("inlineCode",{parentName:"p"},"table()"),"."),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},"table(genes$strand)\n#   -   + \n# 665 678 \n")),(0,o.kt)("p",null,"We can see that the proportion of genes on either strand is approximately equal. What about exon coverage? Let's calculate the proportion of chromosome 19 that encodes exons."),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},'exons <- gff[gff$type=="exon", ]\ndim(exons)\nhead(exons)\n\nexon.lengths <- (exons$end - exons$start) + 1 # adding 1 because of the 1-based coordinate system (start and end positions inclusive)\nchr19.length <- chr19$end + 1\n\n(sum(exon.lengths)) / chr19.length\n# 0.0804416\n')),(0,o.kt)("p",null,"This suggests around 8% of chromosome 19 is annotated as exons for the set of genes classifed as ",(0,o.kt)("em",{parentName:"p"},"ensembl_havana"),"\nCan you carry out a similar calculation to see how much of chromosome 19 codes for protein?"),(0,o.kt)("div",{className:"admonition admonition-note alert alert--secondary"},(0,o.kt)("div",{parentName:"div",className:"admonition-heading"},(0,o.kt)("h5",{parentName:"div"},(0,o.kt)("span",{parentName:"h5",className:"admonition-icon"},(0,o.kt)("svg",{parentName:"span",xmlns:"http://www.w3.org/2000/svg",width:"14",height:"16",viewBox:"0 0 14 16"},(0,o.kt)("path",{parentName:"svg",fillRule:"evenodd",d:"M6.3 5.69a.942.942 0 0 1-.28-.7c0-.28.09-.52.28-.7.19-.18.42-.28.7-.28.28 0 .52.09.7.28.18.19.28.42.28.7 0 .28-.09.52-.28.7a1 1 0 0 1-.7.3c-.28 0-.52-.11-.7-.3zM8 7.99c-.02-.25-.11-.48-.31-.69-.2-.19-.42-.3-.69-.31H6c-.27.02-.48.13-.69.31-.2.2-.3.44-.31.69h1v3c.02.27.11.5.31.69.2.2.42.31.69.31h1c.27 0 .48-.11.69-.31.2-.19.3-.42.31-.69H8V7.98v.01zM7 2.3c-3.14 0-5.7 2.54-5.7 5.68 0 3.14 2.56 5.7 5.7 5.7s5.7-2.55 5.7-5.7c0-3.15-2.56-5.69-5.7-5.69v.01zM7 .98c3.86 0 7 3.14 7 7s-3.14 7-7 7-7-3.12-7-7 3.14-7 7-7z"}))),"Challenge Question")),(0,o.kt)("div",{parentName:"div",className:"admonition-content"},(0,o.kt)("p",{parentName:"div"},"Think about the exonic calculation and result above. Will it over- or under-estimate exon coverage? Why?\nHow could you refine the answer? "))),(0,o.kt)("h2",{id:"plotting-data"},"Plotting data"),(0,o.kt)("p",null,"Now let's make a few plots of the gene annotation data"),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre",className:"language-r"},"regions <- gff[gff$type%in% c('CDS', 'three_prime_UTR', 'five_prime_UTR'), ]\nregions$length <- (regions$end - regions$start) + 1\n\nregion_lengths <- data.frame()      #Create an empty data frame object to store the results\nfor (type in c('CDS', 'three_prime_UTR', 'five_prime_UTR')){\n  region_lengths[type, 'length'] <- sum(regions[regions$type == type, 'length']) # calculate sum of lengths for each region type\n}\n\nbarplot(region_lengths$length, names.arg = rownames(region_lengths))\n")),(0,o.kt)("p",null,(0,o.kt)("img",{alt:"img",src:n(6009).Z,width:"480",height:"480"})),(0,o.kt)("p",null,"Can you hypothesise why the 3' UTR sequences are, on average, longer than 5'?"),(0,o.kt)("p",null,"We saw before that the exonic regions are only a small fraction of the chromsome sequence. To visualise this, let's now add the length of the entire chromosome 19 for scale!"),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre",className:"language-r"},"region_lengths['chromosome', 'length'] <- chr19.length\n\nbarplot(region_lengths$length, names.arg = rownames(region_lengths))\n")),(0,o.kt)("p",null,(0,o.kt)("img",{alt:"img",src:n(6518).Z,width:"480",height:"480"})),(0,o.kt)("h2",{id:"fut-genes"},"FUT genes"),(0,o.kt)("p",null,"Let's look at some interesting genes on chromosome 19. We will look at a class of enzymes called fucosyltarnsferases, which are involved in chemical modification of glycans displayed on the cell surface. There are 13 of them in the entire genome, let's see how many on chromosome 19 - their symbols all start with 'FUT'."),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre",className:"language-r"},'# find all the gene names that contain \'FUT\'\nFUT.genes <- grep(pattern = \'FUT\', gff$Name, value = TRUE) \nFUT.genes\n\n#[1] "FUT6"     "FUT6-202" "FUT6-201"\n#[4] "FUT3"     "FUT3-201" "FUT3-202"\n#[7] "FUT5"     "FUT2"     "FUT2-202"\n#[10] "FUT1"     "FUT1-206"\n')),(0,o.kt)("p",null,"This is interesting - there are some gene symbols as well as some with a dash and a number. Let's take a closer look at their annotations."),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre",className:"language-r"},"subset(gff, Name %in% FUT.genes)[,9:12]\n                              ID Alias     Name        biotype\n# 23031        gene:ENSG00000156413           FUT6 protein_coding\n# 23032  transcript:ENST00000318336       FUT6-202 protein_coding\n# 23061  transcript:ENST00000286955       FUT6-201 protein_coding\n# 23117        gene:ENSG00000171124           FUT3 protein_coding\n# 23118  transcript:ENST00000303225       FUT3-201 protein_coding\n# 23136  transcript:ENST00000458379       FUT3-202 protein_coding\n# 23198        gene:ENSG00000130383           FUT5 protein_coding\n# 147878       gene:ENSG00000176920           FUT2 protein_coding\n# 147886 transcript:ENST00000425340       FUT2-202 protein_coding\n# 148150       gene:ENSG00000174951           FUT1 protein_coding\n# 148151 transcript:ENST00000645652       FUT1-206 protein_coding\n")),(0,o.kt)("p",null,'Bingo! Some annotations are for the genes (ENSG identifiers) and the others correspond to mRNA transcripts (those with the dashes and identifiers beginning with "ENST"). We are only interested in the genes, so let\'s modify our search to reflect that.'),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre",className:"language-r"},'FUT.genes <- grep(\'\\\\-\', FUT.genes, value = TRUE, invert = TRUE) \n# \\\\ is an escape character, which tells grep to look for an actual dash, not a dash symbol with a special meaning.\n# `invert` tells grep to exclude genes containing a dash.\n\n## inspect the new set of matching results\nFUT.genes\n# [1] "FUT6" "FUT3" "FUT5" "FUT2" "FUT1"\n\n## store them in a new object\nFUT.genes_df <- subset(gff, Name %in% FUT.genes)\nFUT.genes_df\n')),(0,o.kt)("p",null,"Let's visualise the relative placement of all the FUT genes using a genome browser. We will use GenomicRanges object, which is a compact way of storing sequence information. We will then use Gviz package to create 'tracks' (in our case, the reference track will be empty, but it can contain information about the genome).\nInstall the packages (if not already downloaded)"),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},'BiocManager::install("GenomicRanges")\nBiocManager::install("Gviz")\nBiocManager::install("GenomicFeatures")\n')),(0,o.kt)("p",null,"Load the libraries"),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},"library(GenomicRanges)\nlibrary(Gviz)\nlibrary(GenomicFeatures)\n")),(0,o.kt)("p",null,"First we prepare the plot (don't worry too much about this code snippet)"),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre"},"FUT.genes_gr <- with(FUT.genes_df, GRanges(seqid, IRanges(start, end), strand, id = Name))\n \nchr_track <- IdeogramTrack(genome = 'hg38', chromosome = 'chr19') # This creates a chromosome 'ideogram', or a graphic, with cytological bands, based on corresponding data from UCSC (another genome resource like Ensembl)\nref_track <- GenomeAxisTrack() # This creates an empty track where our genes will be displayed\ndata_track <- AnnotationTrack(FUT.genes_gr, name = \"Genes\", showFeatureId = TRUE) # This creates the annotations to display\n")),(0,o.kt)("p",null,"When inspecting the data frame ",(0,o.kt)("inlineCode",{parentName:"p"},"FUT.genes_df[,1:10]"),", you can see that there are two clusters of fucosyltransferase genes - one cluster of 3 genes in the 5.8Mb region and another 2 genes in the 48.7Mb region. We will plot these two regions separately as they are far apart."),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre",className:"language-r"},"#Cluster 1\nplotTracks(c(chr_track, ref_track, data_track),\n           from = 5.82e6, to = 5.88e6, sizes = c(1,1,2))\n")),(0,o.kt)("p",null,(0,o.kt)("img",{alt:"img",src:n(7249).Z,width:"480",height:"480"})),(0,o.kt)("pre",null,(0,o.kt)("code",{parentName:"pre",className:"language-r"},"#Cluster 2\nplotTracks(c(chr_track, ref_track, data_track),\n           from = 48.68e6, to = 48.76e6, sizes = c(1,1,2))\n")),(0,o.kt)("p",null,(0,o.kt)("img",{alt:"img",src:n(303).Z,width:"480",height:"480"})),(0,o.kt)("p",null,"Feel free to change the ",(0,o.kt)("inlineCode",{parentName:"p"},"from")," and ",(0,o.kt)("inlineCode",{parentName:"p"},"to")," values to zoom in and out of the loci. You can also produce some code that will automatically establish the optimal region to show using functions ",(0,o.kt)("inlineCode",{parentName:"p"},"min()"),", ",(0,o.kt)("inlineCode",{parentName:"p"},"max()"),", and the arguments ",(0,o.kt)("inlineCode",{parentName:"p"},"extend.right"),"/",(0,o.kt)("inlineCode",{parentName:"p"},"extend.left")," of the function ",(0,o.kt)("inlineCode",{parentName:"p"},"plotTracks"),". The arrows indicate transcript directionality (remember '+' and '-' strands from our GFF? They correspond to right- and left-pointing arrows, respectively)."),(0,o.kt)("p",null,"And that's the end of this tutorial! Now you know how to read in and handle data in R, learned a bit more about gene annotation files and ways to visualise some of the information they contain."))}d.isMDXComponent=!0},6009:(e,t,n)=>{n.d(t,{Z:()=>a});const a="data:image/png;base64,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"},6518:(e,t,n)=>{n.d(t,{Z:()=>a});const a="data:image/png;base64,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"},7249:(e,t,n)=>{n.d(t,{Z:()=>a});const a="data:image/png;base64,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"},303:(e,t,n)=>{n.d(t,{Z:()=>a});const a="data:image/png;base64,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"}}]);