function NavigationContext( menu ) {

	this.default_page = "introduction" ;
	this.menu = "menu" ;
	
	this.onPageChange = function( page ) {
		if( page == "" ) {
			page = this.default_page ;
		}
		$( '.menu a[href!="' + page + '"]' ).removeClass( 'selected' ) ;
		$( '.menu a[href="' + page + '"]' ).addClass( 'selected' ) ;
		$( 'div.section' ).fadeOut(0) ;
		$( '#' + page ).fadeIn(
		    0,
		    function() { $('body').scrollTop(0) ; }
		) ;
	}
}

$(document).ready(
	function() {
		var context = new NavigationContext( $( '.menu' )) ;
		$( 'div.section' ).hide() ;

		$( window ).bind( 'hashchange', function() {
			// Get the page.  Omit the leading '#'.
			var page = location.hash.substring( 1 ) ;
			context.onPageChange( page ) ;
		} ) ;
		
		$( '.menu a' ).click(
			function() {
				location.hash = '#' + $( this ).attr( 'href' ) ;
				return false ;
			}
		) ;
		
		$( window ).trigger( 'hashchange' ) ;
		//$( 'body' ).scrollTop(0);
	}
) ;