/* Code generated by HMMoC version VERSION, Copyright (C) 2006 Gerton Lunter */
/* Generated from file readalign.xml (author:  Gerton Lunter ) on Mon Dec 20 11:41:40 GMT 2010 */

/*
This file is a work based on HMMoC VERSION, a hidden Markov model compiler.
Copyright (C) 2006 by Gerton Lunter, Oxford University.

HMMoC and works based on it are free software; you can redistribute 
it and/or modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

HMMOC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with HMMoC; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _readalign_h_
#define _readalign_h_


#include "dptables.h"
#include "algebras.h"

#include <vector>
#include <iostream>
#include <string>
#include <algorithm>

using std::vector;
using std::cout;
using std::string;

#include <map>

using std::map;


// Here go the state memory clique typedefs:
typedef States<logspace,1> Statesblock4;
typedef States<logspace,1> Statesblock5;
typedef States<logspace,3> Statesblock3;
typedef States<logspace,1> Statesblock2;
typedef States<logspace,1> Statesblock1;

class AlignDPTable {
    public:
    // If true, this class' destructor will delete the DP arrays
    bool isInCharge;
    // Pointers to arrays containing ids of states and transitions
    const string* const stateId;
    const string* const emissionId;
    const string* const transitionId;
    const string* const transitionFrom;
    const string* const transitionTo;
    const string* const transitionProb;
    const string* const transitionEmit;
    const string* const outputId;
    // The actual DP tables, and total sequence lengths (which determine size of DP arrays) follow:
    int iLen1;
    int iLen2;
    DPTable<Statesblock4,1> StateMemoryblock4;
    DPTable<Statesblock5,0> StateMemoryblock5;
    DPTable<Statesblock3,2> StateMemoryblock3;
    DPTable<Statesblock2,1> StateMemoryblock2;
    DPTable<Statesblock1,0> StateMemoryblock1;
    // Member functions:
    public:
    // Default copy constructor is used; user has to set isInCharge appropriately afterwards!
    AlignDPTable(int iLen1,int iLen2);
    ~AlignDPTable();
    // returns probability from DP table, given position and int or string state identifier
    logspace getProb(int iState ,int ,int ) const;
    logspace getProb(const string sState ,int ,int ) const;
    // converts string identifier (for state, transition or emission) into integer id
    static int getId(const string& sState);
    static const string& getTransitionId(int id);
    static const string& getEmissionId(int id);
    static const string& getStateId(int id);
    static const string& getOutputId(int id);
    static void _cleanup() { getId("_cleanup_"); }
};

// give a name to the real type used for this HMM
typedef logspace AlignReal;
// define type for a 'short' real -- usually double, but can be logspace for efficiency
typedef logspace AlignShortReal;




// Here go the state memory clique typedefs:
typedef States<logspace,1> Statesblock4;
typedef States<logspace,1> Statesblock5;
typedef States<logspace,3> Statesblock3withbanding;
typedef States<logspace,1> Statesblock2;
typedef States<logspace,1> Statesblock1;

class AlignBandingDPTable {
    public:
    // If true, this class' destructor will delete the DP arrays
    bool isInCharge;
    // Pointers to arrays containing ids of states and transitions
    const string* const stateId;
    const string* const emissionId;
    const string* const transitionId;
    const string* const transitionFrom;
    const string* const transitionTo;
    const string* const transitionProb;
    const string* const transitionEmit;
    const string* const outputId;
    // The actual DP tables, and total sequence lengths (which determine size of DP arrays) follow:
    int iLen1;
    int iLen2;
    DPTable<Statesblock4,1> StateMemoryblock4;
    DPTable<Statesblock5,0> StateMemoryblock5;
    DPTable<Statesblock3withbanding,2> StateMemoryblock3withbanding;
    DPTable<Statesblock2,1> StateMemoryblock2;
    DPTable<Statesblock1,0> StateMemoryblock1;
    // Member functions:
    public:
    // Default copy constructor is used; user has to set isInCharge appropriately afterwards!
    AlignBandingDPTable(int iLen1,int iLen2);
    ~AlignBandingDPTable();
    // returns probability from DP table, given position and int or string state identifier
    logspace getProb(int iState ,int ,int ) const;
    logspace getProb(const string sState ,int ,int ) const;
    // converts string identifier (for state, transition or emission) into integer id
    static int getId(const string& sState);
    static const string& getTransitionId(int id);
    static const string& getEmissionId(int id);
    static const string& getStateId(int id);
    static const string& getOutputId(int id);
    static void _cleanup() { getId("_cleanup_"); }
};

// give a name to the real type used for this HMM
typedef logspace AlignBandingReal;
// define type for a 'short' real -- usually double, but can be logspace for efficiency
typedef logspace AlignBandingShortReal;






#ifndef _PATH_CLASS_DEFINED_
#define _PATH_CLASS_DEFINED_

class Path {
    //protected:
    public:
    vector<int> transitions;
    public:
    unsigned int size() const {                             // Number of transitions in path
        return transitions.size(); 
    }
    int transition(int i) const {                           // i-th transition
        return transitions[i]; 
    }
    virtual double prob(int) const = 0;                  // i-th transition*emission probability:
    virtual const vector<int>& emission(int) const = 0;  // i-th emission vector
    virtual int fromState(int) const = 0;                // State at from-end of i-th transition
    virtual int toState(int) const = 0;                  // State at to-end of i-th transition
    virtual int nextFrom(int) const = 0;                 // index of next sibling, -1 if no more (always -1 for simple paths)
    virtual int nextTo(int) const = 0;                   // index of child (always i+1 for simple paths), or -1 if no more
    virtual ~Path() {} 
};

ostream& operator<<(ostream& os, const Path& p);

class SimplePath: public Path {
    public:
    vector<double> probs;
    vector<vector<int> > emissions;
    vector<int> froms;
    vector<int> tos;
    public:
    void addEdge(int transition, double prob, vector<int>& emission, int from, int to);
    double prob(int index) const;
    int nextFrom(int index) const;
    int nextTo(int index) const;
    const vector<int>& emission(int index) const;
    int fromState(int index) const;
    int toState(int index) const;
    void reverse();
};  

#endif // _PATH_CLASS_DEFINED_

logspace Viterbi_recurse(AlignDPTable** ppOutTable,char* pQuality1,char* pSequence1,char* pSequence2,int iGapExtendPhred,int iGapOpenPhred,int iInsNucPrior,int iLen1,int iLen2,int iStartMean,int iStartSD);

Path& Viterbi_trace(AlignDPTable* pInTable,char* pQuality1,char* pSequence1,char* pSequence2,int iGapExtendPhred,int iGapOpenPhred,int iInsNucPrior,int iLen1,int iLen2,int iStartMean,int iStartSD, double ambiguity_bias);

logspace ViterbiBanding_recurse(AlignBandingDPTable** ppOutTable,char* pQuality1,char* pSequence1,char* pSequence2,int iGapExtendPhred,int iGapOpenPhred,int iInsNucPrior,int iLen1,int iLen2,int iStartMean,int iStartSD,int iWidth);

Path& ViterbiBanding_trace(AlignBandingDPTable* pInTable,char* pQuality1,char* pSequence1,char* pSequence2,int iGapExtendPhred,int iGapOpenPhred,int iInsNucPrior,int iLen1,int iLen2,int iStartMean,int iStartSD, double ambiguity_bias);

logspace Forward(AlignDPTable** ppOutTable,char* pQuality1,char* pSequence1,char* pSequence2,int iGapExtendPhred,int iGapOpenPhred,int iInsNucPrior,int iLen1,int iLen2,int iStartMean,int iStartSD);

logspace Backward(AlignDPTable** ppOutTable,char* pQuality1,char* pSequence1,char* pSequence2,int iGapExtendPhred,int iGapOpenPhred,int iInsNucPrior,int iLen1,int iLen2,int iStartMean,int iStartSD);

logspace ForwardBanding(AlignBandingDPTable** ppOutTable,char* pQuality1,char* pSequence1,char* pSequence2,int iGapExtendPhred,int iGapOpenPhred,int iInsNucPrior,int iLen1,int iLen2,int iStartMean,int iStartSD,int iWidth);

logspace BackwardBanding(AlignBandingDPTable** ppOutTable,char* pQuality1,char* pSequence1,char* pSequence2,int iGapExtendPhred,int iGapOpenPhred,int iInsNucPrior,int iLen1,int iLen2,int iStartMean,int iStartSD,int iWidth);

#endif // _readalign_h_

/* --- end of HMMoC-generated file --- */
