/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStatistics {
    protected File file;
    protected String hash1;
    protected String hash2;

    public FileStatistics(File f) {
        this.file = f;
        try {
            this.loadChecksums(f);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.file.getName();
    }

    public String getParentName() {
        return this.file.getParentFile().getName();
    }

    public FileStatistics getChild(String name) {
        return new FileStatistics(new File(this.file, name));
    }

    public long getLatestModificationTime() {
        return FileStatistics.getLatestModificationTime(this.file);
    }

    public Date getLatestModificationDate() {
        return new Date(this.getLatestModificationTime());
    }

    public int getDescendentCount() {
        return FileStatistics.getDescendentCount(this.file);
    }

    public int getChildCount() {
        return FileStatistics.getChildCount(this.file, false);
    }

    public long getSize() {
        return FileStatistics.getSize(this.file);
    }

    public boolean containsHiddenFiles() {
        return FileStatistics.containsHiddenFiles(this.file);
    }

    void loadChecksums(File f) throws IOException {
        this.hash1 = this.readChecksum(new File(f.getPath() + ".MD5"));
        this.hash2 = this.readChecksum(new File(f.getPath() + ".MD5+"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readChecksum(File f) throws IOException {
        if (!f.exists()) {
            return null;
        }
        BufferedReader br = null;
        try {
            String str;
            br = new BufferedReader(new FileReader(f));
            String string = str = br.readLine();
            return string;
        }
        finally {
            br.close();
        }
    }

    public String getHash1() {
        return this.hash1;
    }

    public String getHash2() {
        return this.hash2;
    }

    public int getHashCheck() {
        if (null == this.hash1 || null == this.hash2) {
            return 0;
        }
        if (!this.hash1.equals(this.hash2)) {
            return -1;
        }
        return 1;
    }

    public static void sortByName(List<FileStatistics> stats) {
        Collections.sort(stats, new Comparator<FileStatistics>(){

            @Override
            public int compare(FileStatistics a0, FileStatistics a1) {
                return a0.getFile().getName().compareTo(a1.getFile().getName());
            }
        });
    }

    public static void sortByDate(List<FileStatistics> stats) {
        Collections.sort(stats, new Comparator<FileStatistics>(){

            @Override
            public int compare(FileStatistics a0, FileStatistics a1) {
                return a0.getLatestModificationDate().compareTo(a1.getLatestModificationDate());
            }
        });
    }

    public static void sortByChildren(List<FileStatistics> stats) {
        Collections.sort(stats, new Comparator<FileStatistics>(){

            @Override
            public int compare(FileStatistics a0, FileStatistics a1) {
                return new Integer(a0.getChildCount()).compareTo(new Integer(a1.getChildCount()));
            }
        });
    }

    public static void sortByParents(List<FileStatistics> stats) {
        Collections.sort(stats, new Comparator<FileStatistics>(){

            @Override
            public int compare(FileStatistics a0, FileStatistics a1) {
                int i = a0.getParentName().compareTo(a1.getParentName());
                if (0 != i) {
                    return i;
                }
                return a0.getName().compareTo(a1.getName());
            }
        });
    }

    public List<FileStatistics> getChildren() {
        File[] children = this.file.listFiles();
        ArrayList<FileStatistics> lst = new ArrayList<FileStatistics>();
        for (File child : children) {
            lst.add(new FileStatistics(child));
        }
        return lst;
    }

    public List<FileStatistics> getChildren(FileFilter ff) {
        File[] children = this.file.listFiles(ff);
        ArrayList<FileStatistics> lst = new ArrayList<FileStatistics>();
        for (File child : children) {
            lst.add(new FileStatistics(child));
        }
        return lst;
    }

    public String toString() {
        return this.file.toString();
    }

    public static long getLatestModificationTime(File f) {
        if (f.isDirectory()) {
            File[] children;
            long latestChild = 0L;
            for (File child : children = f.listFiles()) {
                long latest = FileStatistics.getLatestModificationTime(child);
                if (latestChild >= latest) continue;
                latestChild = latest;
            }
            return latestChild;
        }
        return f.lastModified();
    }

    public static long getSize(File f) {
        return FileStatistics.getSize(f, false);
    }

    public static long getSize(File f, boolean includeHidden) {
        if (f.isDirectory()) {
            File[] children;
            long totalSize = f.length();
            for (File child : children = f.listFiles()) {
                if (!includeHidden && child.isHidden()) continue;
                totalSize += FileStatistics.getSize(child, includeHidden);
            }
            return totalSize;
        }
        return f.length();
    }

    public static int getChildCount(File f, boolean includeHidden) {
        if (f.isDirectory()) {
            File[] children;
            int count = 0;
            for (File c : children = f.listFiles()) {
                if (!includeHidden && c.isHidden()) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    public static int getDescendentCount(File f) {
        return FileStatistics.getDescendentCount(f, false);
    }

    public static int getDescendentCount(File f, boolean includeHidden) {
        if (f.isDirectory()) {
            File[] children;
            int count = 0;
            for (File child : children = f.listFiles()) {
                if (!includeHidden && child.isHidden()) continue;
                ++count;
                count += FileStatistics.getDescendentCount(child, includeHidden);
            }
            return count;
        }
        return 0;
    }

    public static boolean containsHiddenFiles(File f) {
        if (f.isDirectory()) {
            File[] children;
            for (File child : children = f.listFiles()) {
                if (child.isHidden()) {
                    return true;
                }
                if (!FileStatistics.containsHiddenFiles(child)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

