/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.hapmap;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import uk.ac.ox.well.t2d.lang.SequenceUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinarySNP {
    private String allele1;
    private BigDecimal allele1Frequency;
    private String allele2;
    private BigDecimal allele2Frequency;

    public BinarySNP(String a1) {
        if (null == a1) {
            throw new RuntimeException("Null parameters not permitted");
        }
        this.allele1 = a1.toUpperCase();
        this.allele1Frequency = BigDecimal.ONE;
        this.allele2 = null;
        this.allele2Frequency = BigDecimal.ZERO;
    }

    public BinarySNP(String a1, String a1Freq, String a2) {
        if (null == a1 || null == a2 || null == a1Freq) {
            throw new RuntimeException("Null parameters not permitted");
        }
        BigDecimal freq = null;
        try {
            freq = new BigDecimal(a1Freq);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Invalid Frequency Big Integer. Found: " + a1Freq);
        }
        if (0 > freq.compareTo(BigDecimal.ZERO)) {
            throw new RuntimeException("Allele 1 Frequency must be greater than 0. Found: " + a1Freq);
        }
        if (0 < freq.compareTo(BigDecimal.ONE)) {
            throw new RuntimeException("Allele 1 Frequency must be less than 1. Found: " + a1Freq);
        }
        this.allele1 = a1.toUpperCase();
        this.allele1Frequency = freq;
        this.allele2 = a2.toUpperCase();
        this.allele2Frequency = BinarySNP.reverseFrequency(this.allele1Frequency);
    }

    BinarySNP(String a1, BigDecimal a1Freq, String a2) {
        this.allele1 = a1.toUpperCase();
        this.allele1Frequency = a1Freq;
        this.allele2 = a2.toUpperCase();
        this.allele2Frequency = BinarySNP.reverseFrequency(this.allele1Frequency);
    }

    public String getAllele1() {
        return this.allele1;
    }

    public BigDecimal getAllele1Frequency() {
        return this.allele1Frequency;
    }

    public String getAllele2() {
        return this.allele2;
    }

    public BigDecimal getAllele2Frequency() {
        return this.allele2Frequency;
    }

    public BigDecimal getFrequency(String allele) {
        if (allele.equalsIgnoreCase(this.getAllele1())) {
            return this.getAllele1Frequency();
        }
        if (allele.equalsIgnoreCase(this.getAllele2())) {
            return this.getAllele2Frequency();
        }
        return null;
    }

    public int getAlleleCount() {
        if (null == this.allele2) {
            return 1;
        }
        return 2;
    }

    public boolean isComplimentary() {
        if (null == this.allele2) {
            return false;
        }
        return this.allele1.equals(SequenceUtilities.flip(this.allele2));
    }

    boolean areAllelesEquivalent(BinarySNP bs) {
        Set<String> intersection = this.getCommonAlleles(this, bs);
        int min = Math.min(this.getAlleleCount(), bs.getAlleleCount());
        return intersection.size() == min;
    }

    public boolean areAllelesComplimentary(BinarySNP snp) {
        return this.areAllelesEquivalent(snp.getComplimentarySNP());
    }

    public boolean areAllelesComparable(BinarySNP snp) {
        return this.areAllelesEquivalent(snp) || this.areAllelesComplimentary(snp);
    }

    public BigDecimal getAlleleFrequencyDifference(BinarySNP bs) {
        BinarySNP snp = null;
        if (this.areAllelesEquivalent(bs)) {
            snp = bs;
        } else if (this.areAllelesComplimentary(bs)) {
            snp = bs.getComplimentarySNP();
        } else {
            return null;
        }
        String common = this.getCommonAllele(this, snp);
        return this.getFrequencyDifference(this.getFrequency(common), snp.getFrequency(common));
    }

    String getCommonAllele(BinarySNP snp1, BinarySNP snp2) {
        Set<String> intersection = this.getCommonAlleles(snp1, snp2);
        if (intersection.isEmpty()) {
            return null;
        }
        return intersection.iterator().next();
    }

    Set<String> getCommonAlleles(BinarySNP snp1, BinarySNP snp2) {
        Set<String> set1 = snp1.getAlleleSet();
        Set<String> set2 = snp2.getAlleleSet();
        HashSet<String> intersection = new HashSet<String>();
        intersection.addAll(set1);
        intersection.retainAll(set2);
        return intersection;
    }

    public Set<String> getAlleleSet() {
        HashSet<String> set = new HashSet<String>();
        set.add(this.getAllele1());
        if (null != this.getAllele2()) {
            set.add(this.getAllele2());
        }
        return set;
    }

    BigDecimal getFrequencyDifference(BigDecimal bd1, BigDecimal bd2) {
        if (null == bd1) {
            throw new NullPointerException("bd1 is null");
        }
        if (null == bd2) {
            throw new NullPointerException("bd2 is null");
        }
        BigDecimal bd = bd1.subtract(bd2);
        if (-1 == bd.signum()) {
            bd = bd.negate();
        }
        return bd;
    }

    BinarySNP getComplimentarySNP() {
        if (null == this.getAllele2()) {
            return new BinarySNP(SequenceUtilities.flip(this.getAllele1()));
        }
        return new BinarySNP(SequenceUtilities.flip(this.getAllele1()), this.getAllele1Frequency(), SequenceUtilities.flip(this.getAllele2()));
    }

    static BigDecimal reverseFrequency(BigDecimal d) {
        return BigDecimal.ONE.subtract(d);
    }

    public String toString() {
        if (null == this.getAllele2()) {
            return this.getAllele1() + "/0";
        }
        return this.getAllele1() + "/" + this.getAllele2();
    }

    public String toString2() {
        if (null == this.getAllele2()) {
            return this.getAllele1() + "0";
        }
        return this.getAllele1() + this.getAllele2();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BinarySNP)) {
            return false;
        }
        BinarySNP s2 = (BinarySNP)o;
        if (!this.getAllele1().equals(s2.getAllele1())) {
            return false;
        }
        if (null != this.getAllele2() || null != s2.getAllele2()) {
            if (null == this.getAllele2()) {
                return false;
            }
            if (!this.getAllele2().equals(s2.getAllele2())) {
                return false;
            }
        }
        return this.getAllele1Frequency().equals(s2.getAllele1Frequency());
    }

    public int hashCode() {
        int hash = this.getAllele1().hashCode();
        if (null != this.getAllele2()) {
            hash = hash * 29 + this.getAllele2().hashCode();
        }
        hash = hash * 29 + this.getAllele1Frequency().hashCode();
        return hash;
    }
}

