/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;

public class StreamUtilities {
    public static long cksum(InputStream is) throws IOException {
        int i;
        CRC32 cksum = new CRC32();
        cksum.reset();
        while (-1 != (i = is.read())) {
            cksum.update(i);
        }
        return cksum.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamCopy(InputStream fromStream, OutputStream os) throws IOException {
        try {
            int i;
            while (-1 != (i = fromStream.read())) {
                os.write(i);
            }
        }
        finally {
            try {
                os.flush();
                os.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void fileCopy(InputStream fromStream, File toFile) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(toFile));
        StreamUtilities.streamCopy(fromStream, os);
    }

    public static long byteCount(InputStream fromStream) throws IOException {
        int i;
        long l = 0L;
        while (-1 != (i = fromStream.read())) {
            ++l;
        }
        return l;
    }

    public static String md5(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamUtilities.streamCopy(is, baos);
        return StreamUtilities.md5(baos.toByteArray());
    }

    public static String md5(byte[] ba) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(ba);
            BigInteger number = new BigInteger(1, messageDigest);
            String hashtext = number.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

