/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.lang;

import java.math.BigDecimal;
import java.math.MathContext;

public class BigDecimalGrouper {
    BigDecimal divisor;
    MathContext mc;

    public BigDecimalGrouper(String d) {
        this(new BigDecimal(d));
    }

    public BigDecimalGrouper(BigDecimal d) {
        if (d.equals(BigDecimal.ZERO)) {
            throw new RuntimeException("Divisor of 0 is not permitted. Found: " + d);
        }
        this.divisor = d;
        this.mc = new MathContext(d.scale());
    }

    public BigDecimal getDivisor() {
        return this.divisor;
    }

    public MathContext getMathContext() {
        return this.mc;
    }

    public BigDecimal getGroup(BigDecimal number) {
        BigDecimal bd = number.divideToIntegralValue(this.divisor);
        bd = bd.multiply(this.divisor);
        return bd.setScale(this.divisor.scale());
    }
}

