/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.lang;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalStatistics {
    public static final ResultsFilter TOTAL_FILTER = new TotalFilter();
    public static final ResultsFilter MEAN_FILTER = new MeanFilter();
    public static final ResultsFilter MEDIAN_FILTER = new MedianFilter();
    public static final ResultsFilter SIZE_FILTER = new SizeFilter();
    int scale;
    List<BigDecimal> decs;

    public BigDecimalStatistics() {
        this(3);
    }

    public BigDecimalStatistics(int scale) {
        this.scale = scale;
        this.decs = new ArrayList<BigDecimal>();
    }

    public void add(BigDecimal bd) {
        this.decs.add(bd);
    }

    public void add(int i) {
        this.decs.add(new BigDecimal(i));
    }

    public void add(String str) {
        this.decs.add(new BigDecimal(str));
    }

    public void clear() {
        this.decs.clear();
    }

    public Results calc() {
        Collections.sort(this.decs);
        Results r = new Results();
        r.setSize(this.decs.size());
        r.setTotal(this.total(this.decs));
        r.setMean(this.mean(r.total, r.size));
        r.setMedian(this.median(this.decs));
        return r;
    }

    public BigDecimal total(List<BigDecimal> bds) {
        BigDecimal bd = BigDecimal.ZERO;
        for (BigDecimal i : bds) {
            bd = bd.add(i);
        }
        return bd;
    }

    public BigDecimal mean(BigDecimal total, int count) {
        if (0 == count) {
            return null;
        }
        return total.divide(new BigDecimal(count), this.scale, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    public BigDecimal median(List<BigDecimal> bds) {
        if (0 == bds.size()) {
            return null;
        }
        BigDecimal m1 = bds.get(bds.size() / 2);
        if (0 == bds.size() % 2) {
            BigDecimal m2 = bds.get(bds.size() / 2 - 1);
            return m1.add(m2).divide(new BigDecimal(2), this.scale, RoundingMode.HALF_UP).stripTrailingZeros();
        }
        return m1;
    }

    public static class SizeFilter
    extends ResultsFilter {
        public SizeFilter() {
            super("Size");
        }

        public BigDecimal getData(Results rs) {
            return new BigDecimal(rs.getSize());
        }
    }

    public static class MedianFilter
    extends ResultsFilter {
        public MedianFilter() {
            super("Median");
        }

        public BigDecimal getData(Results rs) {
            return rs.getMedian();
        }
    }

    public static class MeanFilter
    extends ResultsFilter {
        public MeanFilter() {
            super("Mean");
        }

        public BigDecimal getData(Results rs) {
            return rs.getMean();
        }
    }

    public static class TotalFilter
    extends ResultsFilter {
        public TotalFilter() {
            super("Total");
        }

        public BigDecimal getData(Results rs) {
            return rs.getTotal();
        }
    }

    public static abstract class ResultsFilter {
        String name;

        protected ResultsFilter(String nom) {
            this.name = nom;
        }

        public String getName() {
            return this.name;
        }

        public abstract BigDecimal getData(Results var1);
    }

    public static class Results {
        private int size = 0;
        private BigDecimal total = BigDecimal.ZERO;
        private BigDecimal mean = BigDecimal.ZERO;
        private BigDecimal median = BigDecimal.ZERO;

        public int getSize() {
            return this.size;
        }

        public BigDecimal getTotal() {
            return this.total;
        }

        public BigDecimal getMean() {
            return this.mean;
        }

        public BigDecimal getMedian() {
            return this.median;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void setTotal(BigDecimal total) {
            this.total = total;
        }

        public void setMean(BigDecimal mean) {
            this.mean = mean;
        }

        public void setMedian(BigDecimal median) {
            this.median = median;
        }
    }
}

