/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.lang;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;

public class ByteString
implements CharSequence {
    byte[] bytes;

    public ByteString() {
    }

    public ByteString(String str) {
        this.bytes = str.getBytes(Charset.forName("US-ASCII"));
    }

    public ByteString(StringBuilder sb) {
        this.bytes = new byte[sb.length()];
        for (int i = 0; i < sb.length(); ++i) {
            this.bytes[i] = (byte)sb.charAt(i);
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Arrays.hashCode(this.bytes);
        return hash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ByteString)) {
            return false;
        }
        ByteString bs = (ByteString)o;
        return Arrays.equals(this.bytes, bs.bytes);
    }

    public String toString() {
        try {
            return new String(this.bytes, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int length() {
        return this.bytes.length;
    }

    public char charAt(int i) {
        return (char)this.bytes[i];
    }

    public CharSequence subSequence(int start, int end) {
        ByteString bs = new ByteString();
        bs.bytes = Arrays.copyOfRange(this.bytes, start, end);
        return bs;
    }
}

