/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ox.well.t2d.lang.ComparableRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparableGrouper<A> {
    Map<ComparableRange, List<A>> groups = new LinkedHashMap<ComparableRange, List<A>>();

    public void addRange(ComparableRange cr) {
        if (!this.groups.containsKey(cr)) {
            this.groups.put(cr, new ArrayList());
        }
    }

    public Map<ComparableRange, List<A>> getGroups() {
        return this.groups;
    }

    public List<A> getAllGroupData() {
        ArrayList<A> list = new ArrayList<A>();
        for (List<A> l : this.groups.values()) {
            list.addAll(l);
        }
        return list;
    }

    public void addMember(Comparable c, A o) {
        for (ComparableRange cr : this.groups.keySet()) {
            if (!cr.contains(c)) continue;
            this.addMember(cr, o);
        }
    }

    public int getTotalMembers() {
        int i = 0;
        for (List<A> list : this.groups.values()) {
            i += list.size();
        }
        return i;
    }

    void addMember(ComparableRange cr, A o) {
        List<A> list = this.groups.get(cr);
        list.add(o);
    }

    public List<ComparableRange> group(int groupSize, Collection<Comparable> cs) {
        ArrayList<Comparable> list = new ArrayList<Comparable>(cs.size());
        list.addAll(cs);
        Collections.sort(list);
        return null;
    }

    public int scanForwards(int offset, int size, List<? extends Comparable> list) {
        int count = 0;
        Comparable lastNum = null;
        for (int i = offset; i < list.size(); ++i) {
            Comparable c = list.get(i);
            if (count >= size && (null == lastNum || 0 < c.compareTo(lastNum))) {
                return i;
            }
            lastNum = c;
            ++count;
        }
        return list.size();
    }
}

