/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtilities {
    public static String getSplitComponent(String separator, int index, String data) {
        String[] splits = data.split(separator);
        try {
            return splits[index];
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static List<String> splitSeparated(String separator, String data, boolean allowNulls) {
        String[] splits;
        ArrayList<String> list = new ArrayList<String>();
        for (String str : splits = data.split(separator)) {
            String tr = str.trim();
            if (0 != tr.length()) {
                list.add(tr);
                continue;
            }
            if (!allowNulls) continue;
            list.add(null);
        }
        return list;
    }

    public static List<String> splitSeparated(String separator, String data) {
        return StringUtilities.splitSeparated(separator, data, false);
    }

    public static List<String> splitCommaSeparated(String commaSeparated) {
        return StringUtilities.splitSeparated(",", commaSeparated);
    }

    public static String removeDuplicates(String s, String separator) {
        List<String> cells = StringUtilities.splitSeparated(separator, s);
        HashSet<String> valueSet = new HashSet<String>();
        valueSet.addAll(cells);
        if (cells.size() != valueSet.size()) {
            return StringUtilities.format(valueSet, separator);
        }
        return s;
    }

    public static String format(Collection l) {
        return StringUtilities.format(l, ", ");
    }

    public static String format(Collection l, String separator) {
        StringBuilder sb = new StringBuilder();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (null == o) continue;
            sb.append(o.toString());
            if (!it.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String stripPrefixSuffix(String str, String sep) {
        String rval = str;
        if (rval.startsWith(sep)) {
            rval = rval.substring(sep.length(), rval.length());
        }
        if (rval.endsWith(sep)) {
            rval = rval.substring(0, rval.length() - sep.length());
        }
        return rval;
    }

    public static String stripPrefixSuffix(String str, String[] seps) {
        for (String sep : seps) {
            if (!str.startsWith(sep)) continue;
            return StringUtilities.stripPrefixSuffix(str, sep);
        }
        return str;
    }

    public static String toString(Object[] array, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            if (i == array.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static boolean isNullOrEmpty(String str) {
        return null == str || 0 == str.trim().length();
    }

    public static String replaceIf(String str, String target, String replacement) {
        if (str.contains(target)) {
            return str.replace(target, replacement);
        }
        return str;
    }

    public static String removeNonDigits(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (!Character.isDigit(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String leftPad(int i, int length, String pad) {
        String str = Integer.toString(i);
        if (length <= str.length()) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (length > sb.length()) {
            sb.insert(0, pad);
        }
        return sb.toString();
    }

    public static String zeroPad(int i, int length) {
        return StringUtilities.leftPad(i, length, "0");
    }

    public static String groupDigits(Integer i) {
        return StringUtilities.groupDigits(i.toString());
    }

    public static String groupDigits(Long l) {
        return StringUtilities.groupDigits(l.toString());
    }

    public static String groupDigits(String str) {
        if (5 > str.length()) {
            return str;
        }
        return StringUtilities.group(str, ",", 3);
    }

    public static String group(String str, String sep, int every) {
        StringBuilder sb = new StringBuilder();
        int added = 0;
        for (int i = str.length() - 1; i > -1; --i) {
            sb.insert(0, str.charAt(i));
            if (0 != ++added % every) continue;
            sb.insert(0, sep);
        }
        return sb.toString();
    }

    public static String captureAlphaNumeric(String str, boolean isDigit) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            boolean b = Character.isDigit(c);
            if (b != isDigit) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String captureAlpha(String str) {
        return StringUtilities.captureAlphaNumeric(str, false);
    }

    public static String captureNumeric(String str) {
        return StringUtilities.captureAlphaNumeric(str, true);
    }

    public static String removeControlAndWhitespace(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c) || Character.isISOControl(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static Set<String> captureValues(String str) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        String repl = str.replaceAll(",", "\n");
        repl = repl.replaceAll("\t", "\n");
        repl = repl.replaceAll("\"", "");
        repl = repl.replaceAll("'", "");
        String[] splits = repl.split("\n");
        for (int i = 0; i < splits.length; ++i) {
            String cell = splits[i].trim();
            if (cell.isEmpty()) continue;
            set.add(cell);
        }
        return set;
    }
}

