/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.parser;

import uk.ac.ox.well.t2d.parser.CellHandler;
import uk.ac.ox.well.t2d.parser.RecordHandler;

public class CellByCellParser
implements RecordHandler {
    StringBuilder sb;
    char[] separators;
    CellHandler handler;

    public CellByCellParser(CellHandler ch) {
        this('\t', 100, ch);
    }

    public CellByCellParser(char sep, CellHandler ch) {
        this(sep, 100, ch);
    }

    public CellByCellParser(char sep, int len, CellHandler ch) {
        this(new char[]{sep}, len, ch);
    }

    public CellByCellParser(char[] seps, int len, CellHandler ch) {
        this.handler = ch;
        this.separators = seps;
        this.sb = new StringBuilder(len);
    }

    public void setSeparator(char sep) {
        this.separators = new char[]{sep};
    }

    public void setSeparators(char[] seps) {
        this.separators = seps;
    }

    public boolean handleRecord(long lineNumber, CharSequence lineData) throws Exception {
        this.sb.setLength(0);
        int cellIdx = 0;
        if (!this.handler.startRecord((int)lineNumber)) {
            return false;
        }
        for (int i = 0; i < lineData.length(); ++i) {
            char c = lineData.charAt(i);
            if (this.isSeparator(c)) {
                if (!this.handler.handleCell((int)lineNumber, cellIdx, this.sb.toString())) {
                    return true;
                }
                ++cellIdx;
                this.sb.setLength(0);
                continue;
            }
            this.sb.append(c);
        }
        this.handler.handleCell((int)lineNumber, cellIdx, this.sb.toString());
        return this.handler.endRecord((int)lineNumber);
    }

    boolean isSeparator(char c) {
        for (int i = 0; i < this.separators.length; ++i) {
            if (c != this.separators[i]) continue;
            return true;
        }
        return false;
    }
}

