/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.parser;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.ac.ox.well.t2d.lang.StringUtilities;
import uk.ac.ox.well.t2d.parser.CellByCellParser;
import uk.ac.ox.well.t2d.parser.CellHandlerBase;
import uk.ac.ox.well.t2d.parser.LineByLineParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnLoader {
    ColumnHandler ch = new ColumnHandler();
    CellByCellParser ccp = new CellByCellParser(this.ch);
    char toSeparator;
    int[] columnIndexes;

    public ColumnLoader(int ... columnIndexes) {
        this.columnIndexes = columnIndexes;
        this.toSeparator = (char)9;
    }

    public void setFromSeparator(char sep) {
        this.ccp.setSeparator(sep);
    }

    public void setFromSeparators(char[] seps) {
        this.ccp.setSeparators(seps);
    }

    public void setToSeparator(char sep) {
        this.toSeparator = sep;
    }

    public void setFieldDelimiter(char sep) {
        this.ch.fieldDelimiters = new char[]{sep};
    }

    public void setFieldDelimiters(char[] seps) {
        this.ch.fieldDelimiters = seps;
    }

    public List<String[]> toArrayList(File f) throws Exception {
        FileReader fr = new FileReader(f);
        List<String[]> list = this.toArrayList(fr);
        fr.close();
        return list;
    }

    public List<String[]> toArrayList(Reader r) throws Exception {
        for (int i : this.columnIndexes) {
            this.ch.indexesRequired.add(i);
        }
        LineByLineParser llp = this.newLineByLineParser(this.ccp);
        llp.parse(r);
        ArrayList<String[]> retVal = new ArrayList<String[]>();
        retVal.addAll(this.ch.lineList);
        this.ch.clear();
        return retVal;
    }

    public List<String> toStringList(Reader r) throws Exception {
        List<String[]> list = this.toArrayList(r);
        ArrayList<String> retVal = new ArrayList<String>();
        for (Object[] objectArray : list) {
            String str = StringUtilities.toString(objectArray, "" + this.toSeparator);
            retVal.add(str);
        }
        return retVal;
    }

    public List<String> toStringList(File f) throws Exception {
        FileReader fr = new FileReader(f);
        List<String> list = this.toStringList(fr);
        fr.close();
        return list;
    }

    public List<String> toStringList(InputStream is) throws Exception {
        InputStreamReader fr = new InputStreamReader(is);
        List<String> list = this.toStringList(fr);
        fr.close();
        return list;
    }

    public LineByLineParser newLineByLineParser(CellByCellParser ccp) {
        LineByLineParser llp = new LineByLineParser(ccp);
        return llp;
    }

    static class ColumnHandler
    extends CellHandlerBase {
        Set<Integer> indexesRequired = new HashSet<Integer>();
        List<String[]> lineList = new ArrayList<String[]>();
        List<String> columnList = new ArrayList<String>();

        ColumnHandler() {
        }

        public boolean startRecord(int lineNumber) {
            this.columnList.clear();
            return true;
        }

        public boolean handleCell(int lineNumber, int cellIndex, CharSequence cellData) {
            if (this.indexesRequired.contains(cellIndex)) {
                String str = this.formatCell(cellData);
                this.columnList.add(str);
            }
            return true;
        }

        public boolean endRecord(int lineNumber) {
            String[] strs = this.columnList.toArray(new String[this.columnList.size()]);
            this.lineList.add(strs);
            return true;
        }

        public void clear() {
            this.indexesRequired.clear();
            this.lineList.clear();
            this.columnList.clear();
        }
    }
}

