/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.ox.well.t2d.parser.CellHandlerBase;
import uk.ac.ox.well.t2d.parser.MapHandler;

public class LabelledCellHandler
extends CellHandlerBase {
    boolean isLabelLine = true;
    List<String> labelList = new ArrayList<String>();
    Set<String> duplicateLabels = new HashSet<String>();
    Map<String, String> lineData;
    MapHandler handler;

    public LabelledCellHandler(MapHandler mh) {
        this.handler = mh;
    }

    public Set getDuplicateLabels() {
        return Collections.unmodifiableSet(this.duplicateLabels);
    }

    public boolean startRecord(int lineNumber) {
        if (!this.isLabelLine) {
            this.lineData = new LinkedHashMap<String, String>();
        }
        return true;
    }

    public boolean handleCell(int lineNumber, int cellIndex, CharSequence cellData) {
        String str = this.formatCell(cellData);
        if (this.isLabelLine) {
            this.labelList.add(str);
        } else {
            if (cellIndex >= this.labelList.size()) {
                throw new RuntimeException("Too many cells on line " + lineNumber + ". Expecting " + this.labelList.size() + " cells, but found " + (cellIndex + 1) + ". Could there be too many cell delimiters on this line?");
            }
            String label = this.labelList.get(cellIndex);
            if (!this.lineData.containsKey(label)) {
                this.lineData.put(label, str);
            }
        }
        return true;
    }

    public boolean endRecord(int lineNumber) {
        if (this.isLabelLine) {
            HashSet<String> labelSet = new HashSet<String>();
            for (String str : this.labelList) {
                if (labelSet.contains(str)) {
                    this.duplicateLabels.add(str);
                    continue;
                }
                labelSet.add(str);
            }
            this.isLabelLine = false;
            return true;
        }
        return this.handler.handleRecord(lineNumber, this.lineData);
    }
}

