/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.parser;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ox.well.t2d.parser.CellByCellParser;
import uk.ac.ox.well.t2d.parser.LabelledCellHandler;
import uk.ac.ox.well.t2d.parser.LineByLineParser;
import uk.ac.ox.well.t2d.parser.MapHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelledMapLoader {
    protected String keyLabel;
    protected String[] valueLabels;
    protected char[] fromDelimiters;

    public LabelledMapLoader(String kLbl, String ... vLbls) {
        this.keyLabel = kLbl;
        this.valueLabels = vLbls;
        this.fromDelimiters = new char[]{','};
    }

    public void setDelimiter(char c) {
        this.fromDelimiters = new char[]{c};
    }

    public void setDelimiters(char[] cs) {
        this.fromDelimiters = cs;
    }

    public Map<String, List<String>> loadMap(File f) throws Exception {
        Handler handler = new Handler();
        LineByLineParser llp = this.newParser(handler);
        llp.parse(f);
        return handler.map;
    }

    public Map<String, List<String>> loadMap(InputStream is) throws Exception {
        Handler handler = new Handler();
        LineByLineParser llp = this.newParser(handler);
        llp.parse(is);
        return handler.map;
    }

    public Map<String, List<String>> loadMap(Reader reader) throws Exception {
        Handler handler = new Handler();
        LineByLineParser llp = this.newParser(handler);
        llp.parse(reader);
        return handler.map;
    }

    protected LineByLineParser newParser(MapHandler mh) {
        LabelledCellHandler cellHandler = new LabelledCellHandler(mh);
        CellByCellParser cellParser = new CellByCellParser(cellHandler);
        cellParser.setSeparators(this.fromDelimiters);
        LineByLineParser llp = new LineByLineParser(cellParser);
        return llp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Handler
    implements MapHandler {
        Map<String, List<String>> map = new LinkedHashMap<String, List<String>>();

        @Override
        public boolean handleRecord(int recordNumber, Map<String, String> recordData) {
            String key = recordData.get(LabelledMapLoader.this.keyLabel);
            ArrayList<String> al = new ArrayList<String>();
            for (String lbl : LabelledMapLoader.this.valueLabels) {
                String val = recordData.get(lbl);
                al.add(val);
            }
            this.map.put(key, al);
            return true;
        }
    }
}

