/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import uk.ac.ox.well.t2d.parser.RecordHandler;

public class LineByLineParser {
    protected RecordHandler handler;
    protected long lineNumber;

    public LineByLineParser(RecordHandler r) {
        this.handler = r;
        this.lineNumber = 0L;
    }

    public void parse(File in) throws Exception {
        if (!in.exists() || in.isDirectory()) {
            throw new Exception("The file does not exists, or is a directory: " + in);
        }
        FileInputStream fis = new FileInputStream(in);
        this.parse(fis);
    }

    public void parse(InputStream is) throws Exception {
        InputStreamReader isr = new InputStreamReader(is, "ISO-8859-1");
        this.parse(isr);
    }

    public void parse(Reader r) throws Exception {
        String str;
        LineNumberReader reader = new LineNumberReader(r, 0x100000);
        while (null != (str = reader.readLine())) {
            ++this.lineNumber;
            if (this.parseLine(str, this.lineNumber)) continue;
            break;
        }
    }

    protected boolean parseLine(String str, long lineNumber) throws Exception {
        return this.handler.handleRecord(lineNumber, str);
    }
}

