/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.services.asyncx;

import java.nio.CharBuffer;
import java.util.List;
import uk.ac.ox.well.t2d.services.asyncx.SeparatorMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharBufferRecordParser {
    SeparatorMatcher sepMatcher;
    CharBuffer buf;
    CharSequence record;

    public CharBufferRecordParser() {
        this.sepMatcher = new SeparatorMatcher();
    }

    public CharBufferRecordParser(SeparatorMatcher sm) {
        this.sepMatcher = sm;
    }

    public CharBufferRecordParser(List<String> seps) {
        this.sepMatcher = new SeparatorMatcher(seps);
    }

    public void setBuffer(CharBuffer cb) {
        this.buf = cb;
    }

    public boolean seek() {
        this.buf.mark();
        this.record = null;
        int i = 0;
        while (true) {
            if (this.buf.limit() <= this.buf.position()) {
                this.buf.reset();
                if (i > 0) {
                    this.record = this.buf.subSequence(0, i);
                }
                return false;
            }
            if (this.sepMatcher.isSeparator(this.buf)) {
                this.buf.reset();
                this.record = this.buf.subSequence(0, i);
                this.buf.position(this.buf.position() + i + this.sepMatcher.getLastMatchLength());
                return true;
            }
            this.buf.position(this.buf.position() + 1);
            ++i;
        }
    }

    public CharSequence collect() {
        return this.record;
    }
}

