/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.services.asyncx;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeparatorMatcher {
    List<String> separators;
    int lastMatchLength;
    char[][] sepMatrix;
    boolean[] sepFlags;

    public SeparatorMatcher() {
        this.separators = new ArrayList<String>();
        this.separators.add("\n");
        this.separators.add("\r\n");
        this.separators.add("\r");
    }

    public SeparatorMatcher(String sep) {
        this.separators = new ArrayList<String>();
        this.separators.add(sep);
    }

    public SeparatorMatcher(List<String> seps) {
        this.separators = seps;
    }

    void setupSeparatorMatrix(List<String> seps) {
        int length = 0;
        for (String sep : seps) {
            if (sep.length() <= length) continue;
            length = sep.length();
        }
        char[][] mtx = new char[seps.size()][length];
        for (int i = 0; i < seps.size(); ++i) {
            String sep = seps.get(i);
            for (int j = 0; j < sep.length(); ++j) {
                mtx[i][j] = sep.charAt(j);
            }
        }
        this.sepMatrix = mtx;
        this.sepFlags = new boolean[seps.size()];
    }

    public int getLastMatchLength() {
        return 1;
    }

    public boolean isSeparator(CharBuffer cbuf) {
        int position = cbuf.position();
        char c = cbuf.get(position);
        if (c == '\n') {
            return true;
        }
        return c == '\r';
    }
}

