/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.services.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import uk.ac.ox.well.t2d.services.asyncx.BlockingQueueRecycler;
import uk.ac.ox.well.t2d.services.asyncx.Recycler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelReaderService
implements Runnable {
    BlockingQueue<Recycler<ByteBuffer>> source;
    ReadableByteChannel channel;
    BlockingQueue<Recycler<ByteBuffer>> sink;

    public ChannelReaderService(int bufferCount, int bufferCapacity, boolean directBuffer) {
        this.sink = new ArrayBlockingQueue<Recycler<ByteBuffer>>(bufferCount);
        this.source = new ArrayBlockingQueue<Recycler<ByteBuffer>>(bufferCount);
        for (int i = 0; i < bufferCount; ++i) {
            ByteBuffer bb = this.allocate(bufferCapacity, directBuffer);
            BlockingQueueRecycler<ByteBuffer> rcycr = new BlockingQueueRecycler<ByteBuffer>(bb, this.source);
            this.source.add(rcycr);
        }
    }

    public void setChannel(ReadableByteChannel rbc) {
        this.channel = rbc;
    }

    public BlockingQueue<Recycler<ByteBuffer>> getSink() {
        return this.sink;
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted() && this.channel.isOpen()) {
                Recycler<ByteBuffer> rbb = this.source.take();
                if (null == rbb.get()) continue;
                this.read(rbb);
            }
        }
        catch (InterruptedException ie) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void read(Recycler<ByteBuffer> rbb) throws IOException, InterruptedException {
        block8: {
            try {
                ByteBuffer bb = rbb.get();
                bb.clear();
                int bytesRead = this.channel.read(bb);
                if (-1 == bytesRead) {
                    try {
                        this.channel.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.signalEndOfInput();
                    break block8;
                }
                rbb.get().flip();
                this.passToConsumer(rbb);
            }
            catch (ClosedChannelException cce) {
            }
            catch (IOException e) {
                try {
                    this.channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.signalEndOfInput();
                throw e;
            }
        }
    }

    void passToConsumer(Recycler<ByteBuffer> bb) throws InterruptedException {
        this.sink.put(bb);
    }

    void signalEndOfInput() throws InterruptedException {
        this.sink.put(new BlockingQueueRecycler<ByteBuffer>(null, this.source));
    }

    ByteBuffer allocate(int capacity, boolean directBuffer) {
        if (directBuffer) {
            return ByteBuffer.allocateDirect(capacity);
        }
        return ByteBuffer.allocate(capacity);
    }
}

