/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.services.io;

import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import uk.ac.ox.well.t2d.services.asyncx.BlockingQueueRecycler;
import uk.ac.ox.well.t2d.services.asyncx.Recycler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharArrayService
implements Runnable {
    BlockingQueue<Recycler<CharBuffer>> source;
    BlockingQueue<Recycler<char[]>> charArraySource;
    BlockingQueue<Recycler<char[]>> sink;
    CharBuffer currentBuffer;
    Recycler<CharBuffer> currentBufferRecycler;
    char[] currentArray;
    Recycler<char[]> currentArrayRecycler;
    int currentArrayOffset;
    long totalCharsCopied;
    int numberOfArraysFilled;

    public CharArrayService(int arrayCount, int arrayCapacity) {
        this.sink = new ArrayBlockingQueue<Recycler<char[]>>(arrayCount);
        this.charArraySource = new ArrayBlockingQueue<Recycler<char[]>>(arrayCount);
        for (int i = 0; i < arrayCount; ++i) {
            char[] array = new char[arrayCapacity];
            BlockingQueueRecycler<char[]> rcycr = new BlockingQueueRecycler<char[]>(array, this.charArraySource);
            this.charArraySource.add(rcycr);
        }
        this.totalCharsCopied = 0L;
        this.numberOfArraysFilled = 0;
    }

    public void setSource(BlockingQueue<Recycler<CharBuffer>> q) {
        this.source = q;
    }

    public BlockingQueue<Recycler<char[]>> getSink() {
        return this.sink;
    }

    @Override
    public final void run() {
        this.totalCharsCopied = 0L;
        this.numberOfArraysFilled = 0;
        try {
            while (!Thread.interrupted()) {
                this.currentBufferRecycler = this.source.take();
                this.currentBuffer = this.currentBufferRecycler.get();
                if (null == this.currentBuffer) {
                    this.finishUp();
                    this.signalEndOfInput();
                    break;
                }
                this.buffer2Arrays();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void buffer2Arrays() throws InterruptedException {
        try {
            while (this.arrayCopy()) {
            }
        }
        finally {
            this.currentBufferRecycler.recycle();
        }
    }

    final boolean arrayCopy() throws InterruptedException {
        if (null == this.currentArrayRecycler) {
            this.currentArrayRecycler = this.charArraySource.take();
            this.currentArray = this.currentArrayRecycler.get();
        }
        int required = this.currentArray.length - this.currentArrayOffset;
        if (this.currentBuffer.remaining() > required) {
            this.currentBuffer.get(this.currentArray, this.currentArrayOffset, required);
            this.passToConsumer();
            return true;
        }
        if (this.currentBuffer.remaining() == required) {
            this.currentBuffer.get(this.currentArray, this.currentArrayOffset, required);
            this.passToConsumer();
            return false;
        }
        int remaining = this.currentBuffer.remaining();
        this.currentBuffer.get(this.currentArray, this.currentArrayOffset, remaining);
        this.currentArrayOffset += remaining;
        return false;
    }

    final void finishUp() throws InterruptedException {
        if (null != this.currentArray) {
            char[] na = Arrays.copyOf(this.currentArray, this.currentArrayOffset);
            BlockingQueueRecycler<char[]> rna = new BlockingQueueRecycler<char[]>(na);
            this.currentArray = na;
            this.currentArrayRecycler = rna;
            this.currentArrayOffset = 0;
            this.passToConsumer();
        }
    }

    final void passToConsumer() throws InterruptedException {
        this.totalCharsCopied += (long)this.currentArray.length;
        ++this.numberOfArraysFilled;
        this.sink.put(this.currentArrayRecycler);
        this.currentArrayRecycler = null;
        this.currentArray = null;
        this.currentArrayOffset = 0;
    }

    final void signalEndOfInput() throws InterruptedException {
        this.sink.put(new BlockingQueueRecycler<char[]>(null, this.charArraySource));
    }
}

