/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.services.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import uk.ac.ox.well.t2d.services.asyncx.BlockingQueueRecycler;
import uk.ac.ox.well.t2d.services.asyncx.Recycler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharsetDecoderService
implements Runnable {
    BlockingQueue<Recycler<ByteBuffer>> source;
    BlockingQueue<Recycler<CharBuffer>> charBufferSource;
    BlockingQueue<Recycler<CharBuffer>> sink;
    Charset charSet;
    CharsetDecoder decoder;
    long totalCharsDecoded;

    public CharsetDecoderService(Charset cs, int bufferCount, int bufferCapacity) {
        this.charSet = cs;
        this.decoder = cs.newDecoder();
        this.sink = new ArrayBlockingQueue<Recycler<CharBuffer>>(bufferCount);
        this.charBufferSource = new ArrayBlockingQueue<Recycler<CharBuffer>>(bufferCount);
        for (int i = 0; i < bufferCount; ++i) {
            CharBuffer cb = CharBuffer.allocate(bufferCapacity);
            BlockingQueueRecycler<CharBuffer> rcycr = new BlockingQueueRecycler<CharBuffer>(cb, this.charBufferSource);
            this.charBufferSource.add(rcycr);
        }
        this.totalCharsDecoded = 0L;
    }

    public void setSource(BlockingQueue<Recycler<ByteBuffer>> q) {
        this.source = q;
    }

    public BlockingQueue<Recycler<CharBuffer>> getSink() {
        return this.sink;
    }

    @Override
    public void run() {
        this.totalCharsDecoded = 0L;
        this.decoder.reset();
        try {
            while (!Thread.interrupted()) {
                Recycler<ByteBuffer> rbb = this.source.take();
                if (null == rbb.get()) {
                    this.signalEndOfInput();
                    break;
                }
                this.decode(rbb);
            }
        }
        catch (InterruptedException ie) {
        }
        catch (CharacterCodingException cce) {
            try {
                this.signalEndOfInput();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(Recycler<ByteBuffer> rbb) throws InterruptedException, CharacterCodingException {
        try {
            while (!Thread.interrupted()) {
                Recycler<CharBuffer> rcb = this.charBufferSource.take();
                rcb.get().clear();
                CoderResult result = this.decoder.decode(rbb.get(), rcb.get(), false);
                if (result.isUnderflow()) {
                    this.passToConsumer(rcb);
                    break;
                }
                if (result.isOverflow()) {
                    this.passToConsumer(rcb);
                    continue;
                }
                if (!result.isError()) continue;
                result.throwException();
            }
        }
        finally {
            rbb.recycle();
        }
    }

    void passToConsumer(Recycler<CharBuffer> cb) throws InterruptedException {
        this.totalCharsDecoded += (long)cb.get().position();
        cb.get().flip();
        this.sink.put(cb);
    }

    void signalEndOfInput() throws InterruptedException {
        this.sink.put(new BlockingQueueRecycler<CharBuffer>(null, this.charBufferSource));
    }
}

