/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.services.io;

import java.nio.CharBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.ox.well.t2d.services.asyncx.CharBufferRecordParser;
import uk.ac.ox.well.t2d.services.asyncx.Recyclable;
import uk.ac.ox.well.t2d.services.asyncx.Recycler;
import uk.ac.ox.well.t2d.services.asyncx.SeparatorMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordParserService
implements Runnable {
    Logger logger = Logger.getLogger(this.getClass().getName());
    BlockingQueue<Recycler<CharBuffer>> source;
    BlockingQueue<Record> sink;
    PageParser pageParser;

    public RecordParserService(SeparatorMatcher sepMatcher, int sinkSize) {
        this.pageParser = new PageParser(sepMatcher);
        this.sink = new ArrayBlockingQueue<Record>(sinkSize);
    }

    public void setSource(BlockingQueue<Recycler<CharBuffer>> q) {
        this.source = q;
    }

    public BlockingQueue<Record> getSink() {
        return this.sink;
    }

    @Override
    public void run() {
        int i = 0;
        this.pageParser.reset();
        try {
            while (!Thread.interrupted()) {
                Recycler<CharBuffer> rcb = this.source.take();
                ++i;
                if (null != rcb.get()) {
                    this.parse(rcb);
                    continue;
                }
                this.finish();
                break;
            }
            this.logger.info("End of input signalled. Exiting RecordParserService. Total records parsed: " + this.pageParser.getRecordCount() + ", Total Char Buffers: " + i);
        }
        catch (InterruptedException ie) {
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "IO error causing RecordParserService to exit", e);
        }
    }

    public void parse(Recycler<CharBuffer> rcb) throws InterruptedException {
        Record r;
        this.pageParser.nextBuffer(rcb);
        while (null != (r = this.pageParser.nextRecord())) {
        }
    }

    public void finish() throws InterruptedException {
        Record r = this.pageParser.finalRecord();
        if (null != r) {
            // empty if block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PageParser {
        CharBufferRecordParser parser;
        Recycler<CharBuffer> recycler;
        int recordCount;
        String remainder;
        Record dummy;

        PageParser(SeparatorMatcher sm) {
            this.reset();
            this.parser = new CharBufferRecordParser(sm);
            this.dummy = new Record(null, 1);
        }

        int getRecordCount() {
            return this.recordCount;
        }

        void reset() {
            this.recordCount = 0;
            this.remainder = null;
        }

        public void nextBuffer(Recycler<CharBuffer> rcb) {
            this.parser.setBuffer(rcb.get());
            this.recycler = rcb;
        }

        public Record nextRecord() throws InterruptedException {
            if (this.parser.seek()) {
                ++this.recordCount;
                return this.dummy;
            }
            this.recycler.recycle();
            return null;
        }

        public Record finalRecord() {
            if (null != this.remainder) {
                ++this.recordCount;
                return new Record(this.remainder, this.recordCount);
            }
            return null;
        }

        String join(CharSequence cs1, CharSequence cs2) {
            StringBuilder sb = new StringBuilder(cs1.length() + cs2.length());
            sb.append(cs1);
            sb.append(cs2);
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RecordManager {
        Recycler<CharBuffer> rcb;
        boolean complete;
        int recordTotalCount;
        int recordRecycleCount;

        public RecordManager(Recycler<CharBuffer> buf) {
            this.rcb = buf;
            this.complete = false;
            this.recordTotalCount = 0;
            this.recordRecycleCount = 0;
        }

        synchronized Record newRecord(CharSequence cs, int num) {
            ++this.recordTotalCount;
            return new Record(cs, num, this);
        }

        synchronized void complete() throws InterruptedException {
            this.complete = true;
            this.testRecycleBuffer();
        }

        synchronized void recycle() throws InterruptedException {
            ++this.recordRecycleCount;
            this.testRecycleBuffer();
        }

        synchronized void testRecycleBuffer() throws InterruptedException {
            if (this.complete && this.recordRecycleCount == this.recordTotalCount) {
                this.rcb.recycle();
            }
        }
    }

    public class Record
    implements Recyclable {
        int recordNumber;
        CharSequence charSeq;
        RecordManager manager;

        Record(CharSequence cs, int num) {
            this.charSeq = cs;
            this.recordNumber = num;
        }

        Record(CharSequence cs, int num, RecordManager rm) {
            this.charSeq = cs;
            this.recordNumber = num;
            this.manager = rm;
        }

        public int getRecordNumber() {
            return this.recordNumber;
        }

        public CharSequence getContent() {
            return this.charSeq;
        }

        public void recycle() throws InterruptedException {
            if (null != this.manager) {
                this.manager.recycle();
            }
        }
    }
}

