/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.tools;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import uk.ac.ox.well.t2d.tools.CharSequenceEncoder;

public class CharSequenceCompressor
extends CharSequenceEncoder {
    Deflater deflater = new Deflater(-1);
    Inflater inflater;

    CharSequenceCompressor() {
        this(Charset.forName("US-ASCII"));
    }

    public CharSequenceCompressor(Charset cs) {
        super(cs);
        this.deflater.setStrategy(0);
        this.inflater = new Inflater();
    }

    public byte[] encode(CharSequence seq) {
        try {
            DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)this.baos, this.deflater);
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)dos, this.cs);
            for (int i = 0; i < seq.length(); ++i) {
                ((Writer)w).write(seq.charAt(i));
            }
            ((Writer)w).flush();
            ((Writer)w).close();
            byte[] ba = this.baos.toByteArray();
            this.baos.reset();
            this.deflater.reset();
            return ba;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void writeTo(byte[] bytes, Writer w) throws IOException {
        int i;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        InflaterInputStream gis = new InflaterInputStream(bais, this.inflater);
        InputStreamReader r = new InputStreamReader((InputStream)gis, this.cs);
        while ((i = ((Reader)r).read()) != -1) {
            w.write(i);
        }
        this.inflater.reset();
    }
}

