/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class CharSequenceEncoder {
    public static final int DEFAULT_BUFFER_SIZE = 1000000;
    Charset cs;
    ByteArrayOutputStream baos;

    CharSequenceEncoder() {
        this(Charset.forName("US-ASCII"));
    }

    public CharSequenceEncoder(Charset cs) {
        this.cs = cs;
        this.baos = new ByteArrayOutputStream(1000000);
    }

    public byte[] encode(CharSequence seq) {
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)this.baos, this.cs);
            for (int i = 0; i < seq.length(); ++i) {
                ((Writer)w).write(seq.charAt(i));
            }
            ((Writer)w).flush();
            ((Writer)w).close();
            byte[] ba = this.baos.toByteArray();
            this.baos.reset();
            return ba;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CharSequence decode(byte[] bytes) {
        try {
            StringWriter sw = new StringWriter();
            this.writeTo(bytes, sw);
            return sw.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void writeTo(byte[] bytes, Writer w) throws IOException {
        int i;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        InputStreamReader r = new InputStreamReader((InputStream)bais, this.cs);
        while ((i = ((Reader)r).read()) != -1) {
            w.write(i);
        }
    }
}

