/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.tools;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileShuffle
implements Runnable {
    public Logger logger = Logger.getLogger(this.getClass().getName());
    protected File fileIn;
    protected File fileOut;
    protected Integer outCount;
    protected Random random = new SecureRandom();

    public void setFileIn(File fileIn) {
        this.fileIn = fileIn;
    }

    public void setFileOut(File fileOut) {
        this.fileOut = fileOut;
    }

    public void setOutCount(Integer i) {
        this.outCount = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (null == this.outCount) {
                throw new RuntimeException("outCount not set, as required.");
            }
            this.logger.info("Out count has a length of " + this.outCount);
            if (null == this.fileIn) {
                throw new RuntimeException("fileIn not set, as required.");
            }
            if (!this.fileIn.exists()) {
                throw new RuntimeException("Could not find fileIn: " + this.fileIn);
            }
            this.logger.info("Input file: " + this.fileIn.getCanonicalPath());
            if (null == this.fileOut) {
                throw new RuntimeException("fileOut not set, as required.");
            }
            this.logger.info("Output file: " + this.fileOut.getCanonicalPath());
            int inCount = this.lineCount(this.fileIn);
            int oc = this.outCount;
            if (inCount < oc) {
                oc = inCount;
                this.logger.info("Not enough lines in input file. Only able to output: " + inCount);
            }
            Set<Integer> lineNumbers = this.generateRandomNumbers(inCount, oc);
            PrintWriter pw = new PrintWriter(new FileWriter(this.fileOut));
            try {
                this.outputSpecifiedLines(this.fileIn, pw, lineNumbers);
            }
            finally {
                try {
                    pw.close();
                }
                catch (Exception e) {}
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void outputSpecifiedLines(File f, PrintWriter pw, Set<Integer> lineNumbers) throws IOException {
        String str;
        LineNumberReader lnr = new LineNumberReader(new FileReader(f));
        while (null != (str = lnr.readLine())) {
            if (!lineNumbers.contains(lnr.getLineNumber())) continue;
            pw.println(str);
        }
    }

    public Set<Integer> generateRandomNumbers(int lineCountIn, int lineCountOut) {
        HashSet<Integer> set = new HashSet<Integer>();
        while (lineCountOut > set.size()) {
            int i = this.random.nextInt(lineCountIn + 1);
            if (0 == i) continue;
            set.add(i);
        }
        return set;
    }

    public int lineCount(File f) throws IOException {
        String str;
        int i = 0;
        LineNumberReader lnr = new LineNumberReader(new FileReader(f));
        while (null != (str = lnr.readLine())) {
            ++i;
        }
        return i;
    }
}

