/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.ox.well.t2d.lang.StringTransformer;
import uk.ac.ox.well.t2d.tools.CharSequenceEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSorter
implements Runnable {
    public Logger logger = Logger.getLogger(this.getClass().getName());
    public static int RESERVE_MEMORY_SIZE_BYTES = 1000000;
    protected List<String> targetOrder;
    protected File fileIn;
    protected File fileOut;
    protected StringTransformer keyParser;
    protected int minPasses;
    CharSequenceEncoder sequenceEncoder = new CharSequenceEncoder();
    protected LinkedHashMap<String, byte[]> centralMap = new LinkedHashMap();
    protected int chunkSize;
    protected int passCount;
    protected int outputCount;
    protected int missingKeyCount;
    protected byte[] reserveMemory;
    protected PrintWriter pw;

    public FileSorter() {
    }

    public FileSorter(boolean unicode) {
        this();
        this.minPasses = 1;
    }

    public void setTargetOrder(List<String> targetOrder) {
        this.targetOrder = targetOrder;
    }

    public void setFileIn(File fileIn) {
        this.fileIn = fileIn;
    }

    public void setFileOut(File fileOut) {
        this.fileOut = fileOut;
    }

    public void setKeyParser(StringTransformer kp) {
        this.keyParser = kp;
    }

    public void setMinPasses(int mp) {
        if (0 >= mp) {
            throw new RuntimeException("Minimum Number of passes cannot be less than 1");
        }
        this.minPasses = mp;
    }

    @Override
    public void run() {
        try {
            if (null == this.targetOrder) {
                throw new RuntimeException("targetOrder not set, as required.");
            }
            this.logger.info("Target Order has a length of " + this.targetOrder.size());
            if (null == this.fileIn) {
                throw new RuntimeException("fileIn not set, as required.");
            }
            if (!this.fileIn.exists()) {
                throw new RuntimeException("Could not find fileIn: " + this.fileIn);
            }
            this.logger.info("Input file: " + this.fileIn.getCanonicalPath());
            if (null == this.fileOut) {
                throw new RuntimeException("fileOut not set, as required.");
            }
            this.logger.info("Output file: " + this.fileOut.getCanonicalPath());
            this.logger.info("Attempting to sort input file in " + this.minPasses + " passes");
            this.runIt();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void runIt() throws Exception {
        long start = System.currentTimeMillis();
        this.reserveMemory();
        this.passCount = this.minPasses - 1;
        this.increasePassCount();
        this.outputCount = 0;
        this.missingKeyCount = 0;
        this.pw = new PrintWriter(new BufferedWriter(new FileWriter(this.fileOut)));
        int actualPassCount = 0;
        while (this.targetOrder.size() > this.outputCount) {
            this.singlePass(++actualPassCount);
        }
        this.pw.close();
        this.pw = null;
        this.freeReserve();
        long end = System.currentTimeMillis();
        long minutes = (end - start) / 60000L;
        long seconds = (end - start) % 60000L / 1000L;
        this.logger.info("Sort complete in " + actualPassCount + " in " + minutes + " minutes " + seconds + " seconds. " + "Target index size, " + this.targetOrder.size() + " keys missed " + this.missingKeyCount);
    }

    protected void singlePass(int passNumber) throws IOException {
        this.logger.info("Starting pass number " + passNumber + ".");
        long start = System.currentTimeMillis();
        this.setupNextPass();
        LineNumberReader lnr = new LineNumberReader(new FileReader(this.fileIn));
        while (!this.handleLines(passNumber, lnr)) {
        }
        this.logger.info("Printing " + this.centralMap.size() + " lines from pass number " + passNumber);
        int outputThisPass = this.outputPass(this.pw);
        int keysMissedThisPass = this.centralMap.size() - outputThisPass;
        this.logger.info(outputThisPass + " lines printed, " + keysMissedThisPass + " keys missed.");
        this.missingKeyCount += keysMissedThisPass;
        this.outputCount += this.centralMap.size();
        this.centralMap.clear();
        long end = System.currentTimeMillis();
        long minutes = (end - start) / 60000L;
        long seconds = (end - start) % 60000L / 1000L;
        this.logger.info("Pass " + passNumber + " completed in " + minutes + " minutes " + seconds + " seconds.");
    }

    protected void setupNextPass() {
        int fromIndex = this.outputCount;
        int toIndex = this.outputCount + this.chunkSize;
        if (toIndex > this.targetOrder.size()) {
            toIndex = this.targetOrder.size();
        }
        List<String> passList = this.targetOrder.subList(fromIndex, toIndex);
        for (String str : passList) {
            this.centralMap.put(str, null);
        }
        this.logger.info("Starting at key offset " + this.outputCount + ", collecting " + passList.size() + " lines in total.");
    }

    protected boolean handleLines(int passNumber, LineNumberReader lnr) throws IOException {
        try {
            while (true) {
                String line;
                if (null == (line = lnr.readLine())) {
                    return true;
                }
                this.handleLine(passNumber, lnr.getLineNumber(), line);
            }
        }
        catch (OutOfMemoryError oome) {
            this.handleOutOfMemory();
            this.logger.warning("Ran out of memory. Pass count increased to " + this.passCount + ", chunk size decreased to " + this.chunkSize + ". Size of current chunk size reduced to: " + this.centralMap.size());
            return false;
        }
    }

    protected void handleLine(int passNumber, int lineNumber, String line) {
        String key = this.keyParser.transform(line);
        if (null == key) {
            this.logger.warning("Pass " + passNumber + ". Could not find key value in line " + lineNumber + ". All lines are expected to have keys.");
            return;
        }
        if (this.centralMap.containsKey(key)) {
            byte[] zipped = this.sequenceEncoder.encode(line);
            this.centralMap.put(key, zipped);
        }
    }

    protected void increasePassCount() {
        ++this.passCount;
        this.chunkSize = this.targetOrder.size() / this.passCount + this.targetOrder.size() % this.passCount;
    }

    protected int outputPass(PrintWriter pw) throws IOException {
        int lineCount = 0;
        for (Map.Entry<String, byte[]> e : this.centralMap.entrySet()) {
            byte[] bytes = e.getValue();
            if (null == bytes) continue;
            ++lineCount;
            this.sequenceEncoder.writeTo(bytes, pw);
            pw.println();
        }
        pw.flush();
        return lineCount;
    }

    void handleOutOfMemory() {
        try {
            this.recoverMemory();
        }
        catch (OutOfMemoryError e) {
            this.logger.log(Level.SEVERE, "Encountered OutOfMemoryError while performing the outOfMemory method. This was not expected.", e);
        }
    }

    void recoverMemory() {
        this.freeReserve();
        this.increasePassCount();
        this.resizeMap(this.centralMap, this.chunkSize);
        this.reserveMemory();
    }

    void reserveMemory() {
        this.reserveMemory = new byte[RESERVE_MEMORY_SIZE_BYTES];
    }

    void freeReserve() {
        this.reserveMemory = null;
    }

    void resizeMap(Map m, int maxEntries) {
        int i = 0;
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            it.next();
            if (i > maxEntries - 1) {
                it.remove();
            }
            ++i;
        }
    }
}

