/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import uk.ac.ox.well.t2d.parser.ColumnLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetTable
implements Runnable {
    Set<String> superSet = new TreeSet<String>();
    Map<String, Set<String>> subsets = new LinkedHashMap<String, Set<String>>();
    File outputFile;
    String supersetLabel;

    public void setSupersetLabel(String str) {
        this.supersetLabel = str;
    }

    public void setOutputFile(File of) {
        this.outputFile = of;
    }

    public void addSubset(String lbl, File f) throws Exception {
        ColumnLoader cl = new ColumnLoader(0);
        List<String> strs = cl.toStringList(f);
        this.addSubset(lbl, strs);
    }

    public void addSubset(String lbl, Collection<String> coll) throws Exception {
        HashSet<String> hs = new HashSet<String>();
        hs.addAll(coll);
        System.out.println("Adding subset " + lbl + " containing " + coll.size() + " items");
        this.subsets.put(lbl, hs);
        this.superSet.addAll(hs);
    }

    public void addSubset(String lbl, String path) throws Exception {
        this.addSubset(lbl, new File(path));
    }

    @Override
    public void run() {
        try {
            this.runIt();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void runIt() throws Exception {
        PrintWriter pw = new PrintWriter(new FileWriter(this.outputFile));
        this.printHeader(pw);
        for (String snp : this.superSet) {
            this.printBody(pw, snp);
        }
        pw.close();
    }

    public void printBody(PrintWriter pw, String snp) {
        pw.print(snp);
        for (Map.Entry<String, Set<String>> e : this.subsets.entrySet()) {
            pw.print("\t");
            if (e.getValue().contains(snp)) {
                pw.print("Y");
                continue;
            }
            pw.print("N");
        }
        pw.println();
    }

    public void printHeader(PrintWriter pw) {
        pw.print(this.supersetLabel);
        for (String str : this.subsets.keySet()) {
            pw.print("\t");
            pw.print(str);
        }
        pw.println();
    }
}

