/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import uk.ac.ox.well.t2d.parser.CellByCellParser;
import uk.ac.ox.well.t2d.parser.LineByLineParser;
import uk.ac.ox.well.t2d.parser.RecordHandler;
import uk.ac.ox.well.t2d.parser.SimpleCellHandler;
import uk.ac.ox.well.t2d.services.SimpleFileTransformer;

public class TableTransposer
extends SimpleFileTransformer {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    protected String charset = "US-ASCII";
    protected char fieldSep = (char)9;
    protected char recordSep = (char)10;
    protected int columnSizeMax = 100000000;
    protected int concurrentColumnCount = 50;

    public void setConcurrentColumnCount(int i) {
        this.concurrentColumnCount = i;
    }

    public void setColumnSizeMax(int i) {
        this.columnSizeMax = i;
    }

    public void transform(File fi, File fo) throws Exception {
        long start = System.currentTimeMillis();
        FileOutputStream fos = new FileOutputStream(fo);
        FileChannel fc = fos.getChannel();
        ByteBucketManager bbm = new ByteBucketManager(this.concurrentColumnCount, this.columnSizeMax);
        int colCount = this.countColumns(fi);
        this.logger.log(Level.INFO, "Found {0} columns", colCount);
        for (int i = 0; i < colCount; i += this.concurrentColumnCount) {
            long iStart = System.currentTimeMillis();
            this.logger.log(Level.INFO, "Iteration starting at offset: {0}", i);
            this.singlePass(fi, bbm, fc, i);
            long iEnd = System.currentTimeMillis();
            this.logger.log(Level.INFO, "Iteration took: {0} minutes", (iEnd - iStart) / 60000L);
        }
        fc.close();
        long end = System.currentTimeMillis();
        this.logger.info("Finishing Transform, total runtime: " + (end - start) / 1000L + " s");
    }

    public void transform(File fi, PrintWriter pw) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public InputStream toInputStream(File f) throws IOException {
        InputStream is = new FileInputStream(f);
        if (f.getName().endsWith(".gz")) {
            System.out.println("Found file suffix '.gz', now decoding gzipped instream");
            is = new GZIPInputStream(is);
        }
        return is;
    }

    public boolean singlePass(File f, ByteBucketManager bbm, FileChannel fc, int offset) throws Exception {
        InputStream gis = this.toInputStream(f);
        ColumnHandler handler = new ColumnHandler();
        handler.bbm = bbm;
        handler.passOffset = offset;
        CellByCellParser ccp = new CellByCellParser(handler);
        LineByLineParser parser = new LineByLineParser(ccp);
        parser.parse(gis);
        bbm.finish(fc);
        bbm.reset();
        return false;
    }

    public int countColumns(File f) throws Exception {
        InputStream gis = this.toInputStream(f);
        ColumnCounter cc = new ColumnCounter();
        cc.separator = this.fieldSep;
        LineByLineParser parser = new LineByLineParser(cc);
        parser.parse(gis);
        return cc.getSize();
    }

    public class ByteBucket {
        protected CharBuffer charBuffer = CharBuffer.allocate(100);
        protected CharsetEncoder encoder;
        protected ByteBuffer buffer;

        public ByteBucket(int size) {
            this.encoder = Charset.forName(TableTransposer.this.charset).newEncoder();
            this.buffer = ByteBuffer.allocate(size);
        }

        public void reset() {
            this.charBuffer.clear();
            this.buffer.clear();
            this.encoder.reset();
        }

        public boolean hasData() {
            return 0 != this.buffer.position();
        }

        public void write(CharSequence str) {
            this.charBuffer.clear();
            this.charBuffer.append(str);
            this.charBuffer.append(TableTransposer.this.fieldSep);
            this.charBuffer.flip();
            this.encoder.encode(this.charBuffer, this.buffer, false);
        }

        public void finish(FileChannel fc) throws Exception {
            this.charBuffer.clear();
            this.charBuffer.flip();
            this.encoder.encode(this.charBuffer, this.buffer, true);
            this.encoder.flush(this.buffer);
            if (0 < this.buffer.position()) {
                this.buffer.position(this.buffer.position() - 1);
            }
            this.charBuffer.clear();
            this.charBuffer.put(TableTransposer.this.recordSep);
            this.charBuffer.flip();
            this.encoder.reset();
            this.encoder.encode(this.charBuffer, this.buffer, true);
            this.encoder.flush(this.buffer);
            this.buffer.flip();
            fc.write(this.buffer);
        }
    }

    public class ByteBucketManager {
        ByteBucket[] bba;

        public ByteBucketManager(int concurrentColumns, int columnMaxBytes) {
            this.bba = new ByteBucket[concurrentColumns];
            for (int i = 0; i < this.bba.length; ++i) {
                this.bba[i] = new ByteBucket(columnMaxBytes);
            }
        }

        public int getSize() {
            return this.bba.length;
        }

        public boolean handleCell(int pos, CharSequence cseq) {
            if (pos < this.bba.length) {
                this.bba[pos].write(cseq);
                return true;
            }
            return false;
        }

        public void finish(FileChannel fc) throws Exception {
            for (ByteBucket bb : this.bba) {
                if (null == bb || !bb.hasData()) continue;
                bb.finish(fc);
            }
        }

        public void reset() {
            for (ByteBucket bb : this.bba) {
                if (null == bb) continue;
                bb.reset();
            }
        }
    }

    public static class ColumnHandler
    extends SimpleCellHandler {
        int passOffset;
        ByteBucketManager bbm;

        public boolean handleCell(int lineNumber, int cellIndex, CharSequence cellData) {
            if (cellIndex >= this.passOffset) {
                int thisOffset = cellIndex - this.passOffset;
                return this.bbm.handleCell(thisOffset, cellData);
            }
            return true;
        }
    }

    public static class ColumnCounter
    implements RecordHandler {
        char separator;
        int columnCounter = 0;

        public boolean handleRecord(long lineNumber, CharSequence lineData) throws Exception {
            for (int i = 0; i < lineData.length(); ++i) {
                if (this.separator != lineData.charAt(i)) continue;
                ++this.columnCounter;
            }
            return false;
        }

        public int getSize() {
            return this.columnCounter + 1;
        }
    }
}

