/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ox.well.t2d.beans.Bean;
import uk.ac.ox.well.t2d.types.FormatException;

public class ChromosomalRange
extends Bean {
    public static final Pattern RANGE_PATTERN = Pattern.compile("(\\w+):(\\d+)-(\\d+)\\z");
    private String chr;
    private long start;
    private long stop;

    public ChromosomalRange(String str) throws ChromosomalRangeFormatException {
        Matcher m = RANGE_PATTERN.matcher(str);
        if (!m.lookingAt()) {
            throw new ChromosomalRangeFormatException("Expecting a chromosomal range in the form 'Chr':'Start'-'Stop',  for example 10:1-100000. Found: " + str);
        }
        this.chr = m.group(1).toUpperCase();
        this.start = Long.parseLong(m.group(2));
        this.stop = Long.parseLong(m.group(3));
        this.validatePositions();
    }

    public ChromosomalRange(String chr, long start, long stop) throws ChromosomalRangeFormatException {
        this.chr = chr;
        this.start = start;
        this.stop = stop;
        this.validatePositions();
    }

    public ChromosomalRange(String chr, String start, String stop) throws ChromosomalRangeFormatException {
        this(chr, Long.parseLong(start), Long.parseLong(stop));
    }

    void validatePositions() throws ChromosomalRangeFormatException {
        if (this.start > this.stop) {
            throw new ChromosomalRangeFormatException("Expecting a chromosomal range with a start position less than the stop position. Found: " + this.start + " & " + this.stop);
        }
    }

    public String getChromosome() {
        return this.chr;
    }

    public long getStart() {
        return this.start;
    }

    public long getStop() {
        return this.stop;
    }

    public boolean contains(long coord) {
        return this.start <= coord && coord <= this.stop;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChromosomalRange)) {
            return false;
        }
        ChromosomalRange dm = (ChromosomalRange)o;
        if (!this.equals(this.getChromosome(), dm.getChromosome())) {
            return false;
        }
        if (this.getStart() != dm.getStart()) {
            return false;
        }
        return this.getStop() == dm.getStop();
    }

    public int hashCode() {
        int result = this.getChromosome().hashCode();
        result = 29 * result + (int)this.getStart();
        result = 29 * result + (int)this.getStop();
        return result;
    }

    public String toString() {
        return this.chr + ":" + this.start + "-" + this.stop;
    }

    public static class ChromosomalRangeFormatException
    extends FormatException {
        public ChromosomalRangeFormatException(String str) {
            super(str);
        }
    }
}

