/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.util;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import uk.ac.ox.well.t2d.util.SetComparison;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapComparison<K, V>
extends SetComparison<K> {
    public static Logger logger = Logger.getLogger(MapComparison.class.getName());
    private Map<K, V[]> intersectionDifferences;

    public MapComparison(Map<K, V> a, Map<K, V> b) {
        super(a.keySet(), b.keySet());
        this.intersectionDifferences = this.intersection.isEmpty() ? Collections.EMPTY_MAP : this.calcIntersectionDifferences(a, b, this.intersection);
    }

    public Map calcIntersectionDifferences(Map<K, V> m1, Map<K, V> m2, Set<K> intersection) {
        HashMap<K, Object[]> differences = new HashMap<K, Object[]>();
        for (K k : intersection) {
            V v2;
            V v1 = m1.get(k);
            if (this.equals(v1, v2 = m2.get(k))) continue;
            Object nn = this.notNull(v1, v2);
            Object[] vs = (Object[])Array.newInstance(nn.getClass(), 2);
            vs[0] = v1;
            vs[1] = v2;
            differences.put(k, vs);
        }
        return differences;
    }

    public Map<K, V[]> getIntersectionDifferences() {
        return this.intersectionDifferences;
    }

    public static <K, V> MapComparison<K, V> compareMappings(String aLabel, Map<K, V> aData, String bLabel, Map<K, V> bData) {
        MapComparison<K, V> mc = new MapComparison<K, V>(aData, bData);
        logger.info("Comparing sets: " + aLabel + " & " + bLabel);
        logger.info(aLabel + " only set: " + mc.getSetAOnly().size());
        logger.info(bLabel + " only set: " + mc.getSetBOnly().size());
        logger.info("Intersection: " + mc.getIntersection().size());
        logger.info("Intersection differences: " + mc.getIntersectionDifferences().size());
        logger.info("Superset Total: " + mc.getTotalSetCount());
        if (0 != mc.getIntersectionDifferences().size()) {
            for (Map.Entry<K, V[]> e : mc.getIntersectionDifferences().entrySet()) {
                logger.warning("Key " + e.getKey() + ", differing values found: " + e.getValue()[0] + " & " + e.getValue()[1]);
            }
        }
        return mc;
    }
}

