/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async;

import org.slf4j.Logger;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Command;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.ProcessingResult;

public abstract class ProcessingContext<PI, PO> {
    private Command<PI> command = null;
    private Bucket<PO> payloadOut = null;
    private ProcessingResult result = ProcessingResult.FAILURE;
    private int runCount = 0;

    public void setCommand(Command<PI> command) {
        this.command = command;
    }

    public void setPayloadOut(Bucket<PO> payloadOut) {
        this.payloadOut = payloadOut;
    }

    protected void initialize() throws Exception {
    }

    public void run() {
        try {
            if (0 == this.runCount) {
                this.initialize();
            }
            ++this.runCount;
            this.result = this.process();
        }
        catch (Throwable thr) {
            this.getContract().fail(thr);
            this.result = ProcessingResult.FAILURE;
        }
    }

    public ProcessingResult getResult() {
        return this.result;
    }

    public void clear() {
        this.runCount = 0;
        this.command = null;
        this.payloadOut = null;
        this.result = ProcessingResult.FAILURE;
    }

    public ProcessingResult process() throws Exception {
        return this.process(this.getCommand().getBucket().getPayload(), (PO)this.getPayloadOut(), this.getCommand().isEndOfInput());
    }

    public ProcessingResult process(PI pi, Bucket<PO> bo, boolean endOfContract) throws Exception {
        return this.process(pi, bo.getPayload(), endOfContract);
    }

    public ProcessingResult process(PI pi, PO po, boolean endOfContract) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet. Class=" + this.getClass());
    }

    public Command<PI> getCommand() {
        return this.command;
    }

    public Contract getContract() {
        if (null == this.command) {
            throw new NullPointerException("Null Contract at class: " + this.getClass());
        }
        return this.command.getContract();
    }

    public Logger getLogger() {
        return this.command.getContract().getLogger();
    }

    public Bucket<PI> getPayloadIn() {
        return this.command.getBucket();
    }

    public Bucket<PO> getPayloadOut() {
        return this.payloadOut;
    }

    public boolean isEndOfContract() {
        return this.command.isEndOfInput();
    }
}

