/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.bin;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;

public class BinaryUtilities {
    public static float bytesToFloatBe(byte[] bs) {
        ByteBuffer bb = ByteBuffer.wrap(bs);
        FloatBuffer fb = bb.asFloatBuffer();
        return fb.get(0);
    }

    public static long captureLong(byte[] bs, int offset, int length) {
        byte[] array = Arrays.copyOfRange(bs, offset, offset + length);
        return BinaryUtilities.bytesToLongBe(array);
    }

    public static long bytesToLongLe(byte[] b) {
        byte[] flip = BinaryUtilities.flipByteArray(b);
        return BinaryUtilities.bytesToLongBe(flip);
    }

    public static long bytesToLongBe(byte[] b) {
        BigInteger bint = new BigInteger(1, b);
        return bint.longValue();
    }

    public static byte[] longToBytesBe(long l) {
        if (l < 0L) {
            throw new RuntimeException("Negative Longs cannot be converted using this method. Found:  " + l);
        }
        BigInteger bint = BigInteger.valueOf(l);
        byte[] ba = bint.toByteArray();
        if (ba.length > 1 && ba[0] == 0) {
            byte[] nba = new byte[ba.length - 1];
            System.arraycopy(ba, 1, nba, 0, nba.length);
            ba = nba;
        }
        return ba;
    }

    public static byte[] longToBytesLe(long l) {
        byte[] b = BinaryUtilities.longToBytesBe(l);
        return BinaryUtilities.flipByteArray(b);
    }

    public static byte[] longToBytesLe16(long l) {
        long length16 = l & 0xFFFFL;
        return BinaryUtilities.longToBytesLe(length16);
    }

    public static byte[] longToBytesLe32(long l) {
        long length32 = l & 0xFFFFFFFFL;
        return BinaryUtilities.longToBytesLe(length32);
    }

    public static byte[] flipByteArray(byte[] b) {
        byte[] flip = new byte[b.length];
        for (int i = 0; i < b.length; ++i) {
            flip[flip.length - (i + 1)] = b[i];
        }
        return flip;
    }
}

