/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.bin;

import java.util.Collections;
import java.util.Stack;
import uk.ac.ox.well.t2d.async.bin.ByteHandler;

public class CompositeByteHandler
extends ByteHandler {
    protected Stack<ByteHandler> stack = new Stack();

    @Override
    public ByteHandler initialize() {
        for (ByteHandler bh : this.stack) {
            bh.initialize();
        }
        Collections.reverse(this.stack);
        return this;
    }

    public CompositeByteHandler addHandler(ByteHandler bh) {
        this.stack.push(bh);
        return this;
    }

    @Override
    public boolean isActive() {
        return !this.stack.isEmpty();
    }

    @Override
    public boolean next(byte b) throws Exception {
        ++this.index;
        if (!this.stack.empty() && this.stack.peek().next(b)) {
            this.stack.pop();
        }
        while (!this.stack.empty() && !this.stack.peek().isActive()) {
            this.stack.pop();
        }
        if (this.stack.isEmpty()) {
            this.complete();
            return true;
        }
        return false;
    }

    public void complete() {
    }
}

