/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.contracts;

import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.Node;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.contracts.ContractGroup;
import uk.ac.ox.well.t2d.async.processors.BucketBase;
import uk.ac.ox.well.t2d.async.processors.ContextManager;

public abstract class Aggregator<PO>
implements Node<Object, PO> {
    protected Processor<PO> processor;
    protected CxtManager contextManager = new CxtManager();

    @Override
    public void setProcessor(Processor<PO> p) {
        this.processor = p;
    }

    @Override
    public void commence() {
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized void consume(Contract c, Bucket bin, boolean endOfInput) {
        if (!(c instanceof ContractGroup.SiblingContract)) {
            c.fail(new ClassCastException("Expecting a SiblingContract. found: " + c.getClass()));
        }
        ContractGroup.SiblingContract sibC = (ContractGroup.SiblingContract)c;
        ContractGroup grp = sibC.getGroup();
        if (endOfInput) {
            grp.complete(sibC);
        }
        Contract superC = sibC.getSuperContract();
        Object cxt = this.contextManager.getContext(superC);
        this.aggregate(cxt, sibC, bin.getPayload());
        if (grp.isCompleted()) {
            this.contextManager.removeContext(superC);
            this.finishPayload(superC, cxt);
            BucketBase b = new BucketBase();
            b.setPayload(cxt);
            this.processor.consume(superC, b, true);
        }
        bin.recycle();
    }

    protected abstract PO newContext(Contract var1);

    protected abstract void aggregate(PO var1, Contract var2, Object var3);

    protected void finishPayload(Contract superC, PO cxt) {
    }

    public class CxtManager
    extends ContextManager<PO> {
        @Override
        protected PO newContext(Contract c) {
            return Aggregator.this.newContext(c);
        }
    }
}

