/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.contracts;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import uk.ac.ox.well.t2d.async.Contract;

public class BasicContract
extends LinkedHashMap<String, Object>
implements Contract {
    protected String uuid;
    protected Contract parent;
    protected LinkedHashSet<Contract> subContracts = new LinkedHashSet();

    public BasicContract() {
        this(UUID.randomUUID().toString());
    }

    public BasicContract(String id) {
        this.uuid = id;
    }

    public BasicContract(Contract pc) {
        this();
        this.parent = pc;
    }

    @Override
    public Object get(Object key) {
        if (super.containsKey((String)key)) {
            return super.get(key);
        }
        if (null != this.parent) {
            return this.parent.get(key);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (super.containsKey((String)key)) {
            return true;
        }
        if (null != this.parent) {
            return this.parent.containsKey(key);
        }
        return false;
    }

    @Override
    public Contract getSuperContract() {
        return this.parent;
    }

    @Override
    public Set<Contract> getSubContracts() {
        return Collections.unmodifiableSet(this.subContracts);
    }

    @Override
    public String getId() {
        return this.uuid;
    }

    @Override
    public String toString() {
        return this.uuid.toString();
    }

    @Override
    public int hashCode() {
        return this.uuid.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Contract)) {
            return false;
        }
        Contract c = (Contract)o;
        return this.uuid.equals(c.getId());
    }

    public int compareTo(Object o) {
        if (!(o instanceof Contract)) {
            return 1;
        }
        Contract c = (Contract)o;
        return this.getId().compareTo(c.getId());
    }

    @Override
    public Logger getLogger() {
        return this.getSuperContract().getLogger();
    }

    @Override
    public void addSubContract(Contract c) {
        this.subContracts.add(c);
    }

    @Override
    public void fail(Throwable thr) {
        this.getSuperContract().fail(thr);
    }
}

