/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.contracts;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.contracts.BasicContract;

public class ContractGroup {
    protected String uuid;
    protected Contract superContract;
    protected boolean isFinalized = false;
    protected Set<SiblingContract> siblings;
    protected Set<SiblingContract> returnedSiblings;

    public ContractGroup(Contract sc) {
        this(UUID.randomUUID().toString(), sc);
    }

    public ContractGroup(String id, Contract sc) {
        this.uuid = id;
        this.superContract = sc;
        this.siblings = new LinkedHashSet<SiblingContract>();
        this.returnedSiblings = new LinkedHashSet<SiblingContract>();
    }

    public synchronized SiblingContract newContract(boolean finalize) {
        if (this.isFinalized()) {
            throw new RuntimeException("This ContractGroup has been finalized. No further Contracts permitted");
        }
        int index = this.siblings.size();
        String id = this.superContract.getId() + ":" + this.uuid + "~" + index;
        SiblingContract sib = new SiblingContract(id, index);
        this.siblings.add(sib);
        sib.parent = this.superContract;
        this.superContract.addSubContract(sib);
        if (finalize) {
            this.setFinalize();
        }
        return sib;
    }

    public void setFinalize() {
        this.isFinalized = true;
    }

    public Contract getSuperContract() {
        return this.superContract;
    }

    public Set<SiblingContract> getContracts() {
        return Collections.unmodifiableSet(this.siblings);
    }

    public int getSize() {
        return this.siblings.size();
    }

    public boolean isFinalized() {
        return this.isFinalized;
    }

    public void complete(SiblingContract sc) {
        if (!this.siblings.contains(sc)) {
            throw new RuntimeException("Returning sibling contract bucket not known!");
        }
        this.returnedSiblings.add(sc);
    }

    public boolean isCompleted() {
        if (!this.isFinalized()) {
            return false;
        }
        return this.returnedSiblings.size() >= this.siblings.size();
    }

    public class SiblingContract
    extends BasicContract
    implements Comparable {
        protected int index;

        public SiblingContract(String id, int idx) {
            super(id);
            this.index = idx;
        }

        public ContractGroup getGroup() {
            return ContractGroup.this;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isFinal() {
            if (!this.getGroup().isFinalized()) {
                return false;
            }
            int finalIdx = this.getGroup().getSize() - 1;
            return finalIdx == this.getIndex();
        }

        @Override
        public int compareTo(Object o) {
            if (!(o instanceof SiblingContract)) {
                return 1;
            }
            SiblingContract c = (SiblingContract)o;
            return Integer.compare(this.index, c.getIndex());
        }
    }
}

