/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.contracts;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import uk.ac.ox.well.t2d.async.Node;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.contracts.PrimaryContract;
import uk.ac.ox.well.t2d.async.contracts.Terminal;
import uk.ac.ox.well.t2d.async.processors.BucketBase;

public class Contractor<PI, PO> {
    protected Processor<PI> startPoint;
    protected Node<?, PO> endPoint;
    protected Terminal terminal = this.newTerminal();
    protected int waitTime = 60;
    protected TimeUnit timeUnit = TimeUnit.SECONDS;

    protected Terminal newTerminal() {
        return new Terminal();
    }

    public void setWaitTime(int wt, TimeUnit tu) {
        this.waitTime = wt;
        this.timeUnit = tu;
    }

    public void setStartPoint(Processor<PI> sp) {
        this.startPoint = sp;
    }

    public void setEndPoint(Node<?, PO> ep) {
        this.endPoint = ep;
        this.endPoint.setProcessor(this.terminal);
    }

    public PrimaryContract<PO> initiate(PI payload) throws InterruptedException {
        return this.initiate(payload, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrimaryContract<PO> initiate(PI payload, Map<String, Object> meta) throws InterruptedException {
        PrimaryContract pc = new PrimaryContract();
        if (null != meta) {
            pc.putAll(meta);
        }
        PrimaryContract.Notifier not = new PrimaryContract.Notifier();
        pc.addHandler(not);
        not.getLock().lockInterruptibly();
        BucketBase<PI> b = new BucketBase<PI>(payload);
        try {
            this.startPoint.consume(pc, b, true);
            while (!not.hasCompleted()) {
                not.getCondition().await(this.waitTime, this.timeUnit);
            }
        }
        finally {
            not.getLock().unlock();
        }
        return pc;
    }
}

