/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.contracts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.contracts.BasicContract;
import uk.ac.ox.well.t2d.async.contracts.CompletionHandler;

public class PrimaryContract<P>
extends BasicContract {
    protected Logger logger = LoggerFactory.getLogger(PrimaryContract.class);
    protected boolean isCompleted = false;
    protected List<CompletionHandler<P>> handlers = new ArrayList<CompletionHandler<P>>();
    protected List<Throwable> failures = new ArrayList<Throwable>();
    protected List<P> results = new ArrayList<P>();
    protected boolean completeOnFail = true;

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public List<Throwable> getFailures() {
        return this.failures;
    }

    public PrimaryContract addHandler(CompletionHandler hdlr) {
        this.handlers.add(hdlr);
        return this;
    }

    public List<CompletionHandler<P>> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    public List<P> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    @Override
    public void fail(Throwable thr) {
        thr.printStackTrace(System.err);
        System.err.flush();
        this.failures.add(thr);
        if (this.completeOnFail) {
            this.completed();
        }
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void addPayload(P payload) {
        this.results.add(payload);
    }

    public void completed() {
        this.isCompleted = true;
        for (CompletionHandler<P> ch : this.handlers) {
            ch.completed(this);
        }
    }

    public static class Notifier<P>
    implements CompletionHandler {
        final Lock lock = new ReentrantLock();
        final Condition condition = this.lock.newCondition();
        boolean hasCompleted = false;

        public Lock getLock() {
            return this.lock;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public boolean hasCompleted() {
            return this.hasCompleted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(PrimaryContract pc) {
            this.lock.lock();
            try {
                this.hasCompleted = true;
                this.getCondition().signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

