/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.contracts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.Node;
import uk.ac.ox.well.t2d.async.Processor;
import uk.ac.ox.well.t2d.async.contracts.ContractGroup;

public class Resequencer<PI>
implements Node<PI, PI> {
    protected Processor<PI> nextProcessor;
    protected Map<ContractGroup, SibContractReindexer> map = new HashMap<ContractGroup, SibContractReindexer>();

    @Override
    public void setProcessor(Processor<PI> p) {
        this.nextProcessor = p;
    }

    @Override
    public void commence() {
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized void consume(Contract c, Bucket<PI> bin, boolean endOfInput) {
        if (!(c instanceof ContractGroup.SiblingContract)) {
            c.fail(new ClassCastException("Expecting a SiblingContract. found: " + c.getClass()));
        }
        ContractGroup.SiblingContract sc = (ContractGroup.SiblingContract)c;
        SibContractReindexer ridx = this.getReindexer(sc.getGroup());
        ridx.consume(sc, bin, endOfInput);
        if (ridx.isFinished()) {
            this.map.remove(sc.getGroup());
        }
    }

    protected SibContractReindexer getReindexer(ContractGroup cg) {
        SibContractReindexer ridx = this.map.get(cg);
        if (null == ridx) {
            ridx = new SibContractReindexer(cg);
            this.map.put(cg, ridx);
        }
        return ridx;
    }

    public class SibContractCache {
        protected ContractGroup.SiblingContract sib;
        protected boolean isEndOfInput;
        protected List<Bucket<PI>> buckets;

        public SibContractCache(ContractGroup.SiblingContract sc) {
            this.sib = sc;
            this.buckets = new ArrayList();
        }

        public boolean isCurrent(int currentIndex) {
            return this.sib.getIndex() == currentIndex;
        }

        public void cache(Bucket<PI> bckt, boolean eoi) {
            this.buckets.add(bckt);
            this.isEndOfInput = eoi;
        }

        public boolean hasFinished() {
            return this.isEndOfInput && this.buckets.isEmpty();
        }

        public void send(Processor p) {
            Iterator it = this.buckets.iterator();
            while (it.hasNext()) {
                Bucket bkt = it.next();
                boolean isFinal = !it.hasNext() && this.isEndOfInput;
                p.consume(this.sib, bkt, isFinal);
                it.remove();
            }
        }
    }

    public class SibContractReindexer {
        protected ContractGroup contractGroup;
        protected int currentIndex;
        protected TreeMap<ContractGroup.SiblingContract, SibContractCache> cacheMap;

        public SibContractReindexer(ContractGroup grp) {
            this.contractGroup = grp;
            this.currentIndex = 0;
            this.cacheMap = new TreeMap();
        }

        public boolean isFinished() {
            return this.contractGroup.isFinalized() && this.currentIndex >= this.contractGroup.getSize();
        }

        public void consume(ContractGroup.SiblingContract sc, Bucket<PI> bin, boolean endOfInput) {
            this.getCache(sc).cache(bin, endOfInput);
            this.send();
        }

        protected void send() {
            SibContractCache cache;
            Iterator<SibContractCache> it = this.cacheMap.values().iterator();
            while (it.hasNext() && (cache = it.next()).isCurrent(this.currentIndex)) {
                cache.send(Resequencer.this.nextProcessor);
                if (!cache.hasFinished()) break;
                it.remove();
                ++this.currentIndex;
            }
        }

        protected SibContractCache getCache(ContractGroup.SiblingContract sc) {
            SibContractCache cache = this.cacheMap.get(sc);
            if (null == cache) {
                cache = new SibContractCache(sc);
                this.cacheMap.put(sc, cache);
            }
            return cache;
        }

        public int getBucketCount() {
            int i = 0;
            for (SibContractCache scc : this.cacheMap.values()) {
                i += scc.buckets.size();
            }
            return i;
        }
    }
}

