/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.digest;

import java.nio.CharBuffer;
import uk.ac.ox.well.t2d.async.BasicProcessor;
import uk.ac.ox.well.t2d.async.Bucket;
import uk.ac.ox.well.t2d.async.Contract;
import uk.ac.ox.well.t2d.async.contracts.PrimaryContract;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.SubSection;
import uk.ac.ox.well.t2d.async.gzip.GzipAwarePathFinder;
import uk.ac.ox.well.t2d.async.gzip.GzipDecoder;
import uk.ac.ox.well.t2d.async.gzip.GzipDecoderBypass;
import uk.ac.ox.well.t2d.async.io.AsynchronousFileChannelReader;
import uk.ac.ox.well.t2d.async.io.MessageDigester;
import uk.ac.ox.well.t2d.async.metadata.FileWrtrBlock;
import uk.ac.ox.well.t2d.async.metadata.MetadataReader;
import uk.ac.ox.well.t2d.async.testing.ExecutionRig;

public class MessageDigesterBlck
extends SubSection {
    public void compose() {
        this.addProcessor(new MetadataReader().setPropertyKey("IOProperties.IN_PATH").setIsRequired(true));
        this.addProcessor(new GzipAwarePathFinder());
        this.addProcessor(new GzipDecoderBypass.Sensor());
        this.addProcessor(new AsynchronousFileChannelReader());
        GzipDecoderBypass gzipBypass = new GzipDecoderBypass();
        this.addProcessor(gzipBypass);
        super.addProcessor(new GzipDecoder());
        MessageDigester digest = new MessageDigester();
        this.addProcessor(digest);
        this.addProcessor(new MessageDigestTransformer());
        gzipBypass.setBypassProcessor(digest);
        this.addProcessor(new FileWrtrBlock.CharWrtr());
    }

    @Override
    public void commence() {
        this.compose();
        super.commence();
    }

    public static class Rig
    extends ExecutionRig {
        @Override
        public PrimaryContract execute() throws Exception {
            return this.execute(new MessageDigesterBlck());
        }
    }

    public class MessageDigestTransformer
    extends BasicProcessor {
        @Override
        public void consume(Contract c, Bucket bin, boolean endOfInput) {
            MessageDigester.MessageDigestResult result = (MessageDigester.MessageDigestResult)bin.getPayload();
            String md5String = result.getHexDigest();
            CharBuffer cb = CharBuffer.wrap(md5String);
            bin.setPayload(cb);
            this.getProcessor().consume(c, bin, endOfInput);
        }
    }
}

