/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.exec;

import uk.ac.ox.well.t2d.async.contracts.PrimaryContract;
import uk.ac.ox.well.t2d.async.genotype.clusterplot.ClusterPlotterBlock;
import uk.ac.ox.well.t2d.async.genotype.illumina.FinalReportTransformerBlock;
import uk.ac.ox.well.t2d.async.taqman.rig.SeriesBlock;
import uk.ac.ox.well.t2d.async.testing.ExecutionRig;

public class Main
extends ExecutionRig {
    public static final String TASK_ID_KEY = "task_id";

    public static void main(String[] args) throws Exception {
        Main rig = new Main();
        String propertiesPath = null;
        String defaultPropertiesPath = null;
        if (args.length > 0) {
            propertiesPath = args[0];
        }
        if (args.length > 1) {
            defaultPropertiesPath = args[1];
        }
        rig.initialize(propertiesPath, defaultPropertiesPath);
        rig.execute();
    }

    @Override
    public PrimaryContract execute() throws Exception {
        if (null == this.blck) {
            this.blck = this.bootstrapBlock();
        }
        return this.execute(this.blck);
    }

    public SeriesBlock bootstrapBlock() {
        String task_id = (String)this.get(TASK_ID_KEY);
        if (null == task_id || task_id.isEmpty()) {
            throw new RuntimeException("No TaskId property found in the Properties file.");
        }
        if ("ClusterPlot".equalsIgnoreCase(task_id)) {
            LOGGER.info("Loading logic for Cluster Plotting");
            return new ClusterPlotterBlock();
        }
        if ("IlluminaFinalReportTransform".equalsIgnoreCase(task_id)) {
            LOGGER.info("Loading logic for Illumina Final Report Transformation");
            return new FinalReportTransformerBlock();
        }
        if ("LegacyClusterPlot".equalsIgnoreCase(task_id)) {
            LOGGER.info("Loading logic for Cluster Plotting (legacy naming scheme)");
            return new ClusterPlotterBlock(true);
        }
        LOGGER.info("Loading logic for Cluster Plotting (legacy naming scheme)");
        return new ClusterPlotterBlock(true);
    }
}

