/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.well.t2d.async.genotype.affymetrix;

import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ox.well.t2d.async.bin.ByteHandler;
import uk.ac.ox.well.t2d.async.bin.CompositeByteHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.IntHandler;
import uk.ac.ox.well.t2d.async.bin.handlers.UTF8StringHandler;

public abstract class ColumnDefinitionTriplet
extends CompositeByteHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(ColumnDefinitionTriplet.class);
    private String name;
    private int type;
    private int size;

    @Override
    public ByteHandler initialize() {
        this.addHandler(new UTF8StringHandler(){

            @Override
            public void setString(String str) throws Exception {
                ColumnDefinitionTriplet.this.setName(str);
            }
        }.setLabel("ColumnDefinitionTriplet: Name"));
        this.addHandler(new IntHandler(){

            @Override
            public void setInt(int i) throws Exception {
                ColumnDefinitionTriplet.this.setType(i);
            }
        }.setByteLength(1).setLabel("ColumnDefinitionTriplet: Type"));
        this.addHandler(new IntHandler(){

            @Override
            public void setInt(int i) throws Exception {
                ColumnDefinitionTriplet.this.setSize(i);
            }
        }.setLabel("ColumnDefinitionTriplet: Size"));
        return super.initialize();
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("Nam=%s, Typ=%s, Siz=%s", this.getName(), this.getTypeLabel(), this.getSize());
        return f.toString();
    }

    public String getTypeLabel() {
        return this.getTypeLabel(this.getType());
    }

    public String getTypeLabel(int i) {
        switch (i) {
            case 0: {
                return "BYTE";
            }
            case 1: {
                return "UBYTE";
            }
            case 2: {
                return "SHORT";
            }
            case 3: {
                return "USHORT";
            }
            case 4: {
                return "INT";
            }
            case 5: {
                return "UINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "STRING";
            }
            case 8: {
                return "USTRING";
            }
        }
        throw new IllegalArgumentException("" + i);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

